/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.client.GameSessionState;
import mythruna.client.character.CharacterDecorator;
import mythruna.client.character.CharacterDecorators;
import mythruna.net.GameSession;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClothingViewState.class);
    private GameSession session;
    private Thread renderThread;
    private JobState workers;
    private AssetManager assets;
    private ConcurrentHashMap<EntityId, ClothingView> viewIndex = new ConcurrentHashMap();

    public void updateClothing(EntityId id, Spatial spatial, ShapeName shapeName) {
        log.info("updateClothing(" + id + ", " + shapeName + ")");
        ClothingView view = this.viewIndex.get(id);
        if (view == null && !this.hasAppearanceStuff(shapeName)) {
            return;
        }
        if (view == null) {
            log.info("creating new view");
            view = new ClothingView(id, spatial, shapeName);
            this.viewIndex.put(id, view);
        } else if (view != null) {
            log.info("using existing view");
            view.update(spatial, shapeName);
        }
        view.validate();
    }

    public void releaseClothing(EntityId id, Spatial spatial) {
        log.info("releaseClothing(" + id + ")");
        ClothingView view = this.viewIndex.remove(id);
        if (view != null) {
            view.release();
        }
    }

    protected boolean hasAppearanceStuff(ShapeName shapeName) {
        for (ShapeName addOn : shapeName.getAddOns()) {
            if ("fab".equals(addOn.getType())) {
                return true;
            }
            if ("sc".equals(addOn.getType())) {
                return true;
            }
            if (!"hc".equals(addOn.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.session = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        this.workers = (JobState)this.getState(JobState.class, true);
        this.assets = this.getApplication().getAssetManager();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    private class ClothingView
    implements Job {
        private EntityId entityId;
        private Spatial spatial;
        private ShapeName shapeName;
        private CharacterDecorator decorator;
        private boolean updateSpatial;
        private boolean updateShapeName;
        private boolean queued;

        public ClothingView(EntityId entityId, Spatial spatial, ShapeName shapeName) {
            log.info("ClothingView(" + spatial + ", " + shapeName + ")");
            this.entityId = entityId;
            this.spatial = spatial;
            this.shapeName = shapeName;
            this.decorator = CharacterDecorators.standardDecorators(ClothingViewState.this.assets, id -> ClothingViewState.this.session.getCellArray(id));
            this.updateSpatial = true;
            this.updateShapeName = true;
        }

        public boolean isInvalid() {
            return this.updateSpatial || this.updateShapeName;
        }

        public void validate() {
            log.info("validate():" + this.entityId);
            if (!this.isInvalid()) {
                return;
            }
            if (!ClothingViewState.this.isRenderThread()) {
                log.info("Already on a background thread:" + this.entityId);
                this.runOnWorker();
                if (this.spatial.getParent() == null) {
                    log.info("Not attached yet:" + this.entityId);
                    this.runOnUpdate();
                    return;
                }
            }
            ClothingViewState.this.workers.execute((Job)this, -1);
        }

        public void update(Spatial spatial, ShapeName shapeName) {
            log.info("update(" + spatial + ", " + shapeName + ")");
            if (this.spatial != spatial) {
                log.info("*** spatial has changed");
                this.spatial = spatial;
                this.updateSpatial = true;
            }
            if (!Objects.equals(shapeName, this.shapeName)) {
                log.info("*** shapeName has changed");
                this.shapeName = shapeName;
                this.updateShapeName = true;
            }
        }

        public void release() {
        }

        public void runOnWorker() {
            if (this.updateSpatial) {
                this.decorator.setSpatial(this.spatial);
                this.updateSpatial = false;
            }
            if (this.updateShapeName) {
                this.decorator.setShapeName(this.shapeName);
                this.updateShapeName = false;
            }
            if (this.spatial.getParent() == null) {
                this.decorator.apply();
            }
        }

        public double runOnUpdate() {
            double work = 0.0;
            if (this.decorator.apply()) {
                work += 0.1;
            }
            return work;
        }
    }
}

