/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.Objects;

public class AttachedTo
implements EntityComponent,
PersistentComponent {
    private EntityId parent;
    private Vec3d offset;
    private Quatd rotation;
    private int attachmentId;

    public AttachedTo() {
    }

    public AttachedTo(EntityId parent, int attachmentId) {
        this(parent, new Vec3d(), new Quatd(), attachmentId);
    }

    public AttachedTo(EntityId parent, Vec3d offset, Quatd rotation) {
        this(parent, offset, rotation, -1);
    }

    public AttachedTo(EntityId parent, Vec3d offset, Quatd rotation, int attachmentId) {
        this.parent = parent;
        this.offset = offset;
        this.rotation = rotation;
        this.attachmentId = attachmentId;
    }

    public static AttachedTo create(EntityId parent, String attachmentName, EntityData ed) {
        return AttachedTo.create(parent, attachmentName, new Vec3d(), new Quatd(), ed);
    }

    public static AttachedTo create(EntityId parent, String attachmentName, Vec3d offset, Quatd rotation, EntityData ed) {
        int id = ed.getStrings().getStringId(attachmentName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(attachmentName, true);
        }
        AttachedTo result = new AttachedTo(parent, offset, rotation, id);
        return result;
    }

    public EntityId getParent() {
        return this.parent;
    }

    public int getAttachmentId() {
        return this.attachmentId;
    }

    public String getAttachmentName(EntityData ed) {
        if (this.attachmentId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.attachmentId);
    }

    public Vec3d getOffset() {
        return this.offset;
    }

    public Quatd getRotation() {
        return this.rotation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AttachedTo other = (AttachedTo)o;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.offset, other.offset)) {
            return false;
        }
        if (!Objects.equals(this.rotation, other.rotation)) {
            return false;
        }
        return other.attachmentId == this.attachmentId;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.offset, this.rotation, this.attachmentId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.attachmentId) : this.getAttachmentName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("parent", (Object)this.parent).add("offset", (Object)this.offset).add("rotation", (Object)this.rotation).add("attachmentId", (Object)s).toString();
    }
}

