/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import mythruna.world.DefaultWorldFractal;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalTerrainImageGenerator
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(FractalTerrainImageGenerator.class);
    private int seaLevel = 128;
    private int treeLine = 500;
    private WorldFractal fractal;
    double overallMinTemperature = Double.POSITIVE_INFINITY;
    double overallMinWeather = Double.POSITIVE_INFINITY;
    double overallMinEcology = Double.POSITIVE_INFINITY;
    double overallMaxTemperature = Double.NEGATIVE_INFINITY;
    double overallMaxWeather = Double.NEGATIVE_INFINITY;
    double overallMaxEcology = Double.NEGATIVE_INFINITY;

    public FractalTerrainImageGenerator(WorldFractal fractal) {
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() < 0L) {
            this.generateTerrain(terrain);
        }
        if (fluid.getVersion().getLoadVersion() < 0L) {
            int size = fluid.getSize();
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    short elev = terrain.getElevation(x, z);
                    if (elev < this.seaLevel) {
                        fluid.setElevation(x, z, (short)this.seaLevel);
                        fluid.setType(x, z, (byte)1);
                        byte type = terrain.getType(x, z);
                        terrain.setType(x, z, TerrainTypes.setFoliageLevel(type, 0));
                        continue;
                    }
                    fluid.setElevation(x, z, (short)this.seaLevel);
                    fluid.setType(x, z, (byte)-1);
                }
            }
            fluid.getVersion().markChanged();
        }
    }

    protected synchronized void updateRanges(double temperature, double weather, double ecology) {
        this.overallMinTemperature = Math.min(this.overallMinTemperature, temperature);
        this.overallMaxTemperature = Math.max(this.overallMaxTemperature, temperature);
        this.overallMinWeather = Math.min(this.overallMinWeather, weather);
        this.overallMaxWeather = Math.max(this.overallMaxWeather, weather);
        this.overallMinEcology = Math.min(this.overallMinEcology, ecology);
        this.overallMaxEcology = Math.max(this.overallMaxEcology, ecology);
    }

    private double clamp(double val, double min, double max) {
        if (val <= min) {
            return min;
        }
        if (val >= max) {
            return max;
        }
        return val;
    }

    protected double remapEcology(double ecology) {
        if (ecology > 0.5) {
            return 1.0;
        }
        return ecology * 2.0;
    }

    protected double remapTemperature(double value) {
        if (value < 0.3) {
            return 0.0;
        }
        if (value > 0.7) {
            return 1.0;
        }
        return (value - 0.3) / 0.4;
    }

    protected double remapWeather(double value) {
        if (value < 0.25) {
            return 0.0;
        }
        if (value > 0.7) {
            return 1.0;
        }
        return (value - 0.25) / 0.44999999999999996;
    }

    protected void generateTerrain(TerrainImage target) {
        TerrainImageId id = target.getId();
        Vec3i world = id.getTileId().getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        int scale = 1024 / id.getResolution().getSamples();
        short[] elevations = target.getElevations();
        byte[] types = target.getTypes();
        int size = target.getSize();
        boolean pos = false;
        double minTemperature = Double.POSITIVE_INFINITY;
        double minWeather = Double.POSITIVE_INFINITY;
        double minEcology = Double.POSITIVE_INFINITY;
        double maxTemperature = Double.NEGATIVE_INFINITY;
        double maxWeather = Double.NEGATIVE_INFINITY;
        double maxEcology = Double.NEGATIVE_INFINITY;
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                double weather;
                double xp = xCorner + (double)(x * scale);
                double zp = zCorner + (double)(z * scale);
                double yp = this.fractal.getElevation(xp, zp);
                int elevation = (int)yp;
                target.setElevation(x, z, (short)elevation);
                boolean baseType = false;
                boolean foliage = false;
                boolean wetness = false;
                boolean frozen = false;
                double temperature = this.fractal.getTemperature(xp, yp, zp);
                double rescale = DefaultWorldFractal.rescale;
                elevation = (int)((double)this.seaLevel + (double)(elevation - this.seaLevel) * rescale);
                double height = (double)Math.abs(elevation - this.seaLevel) / (double)this.treeLine;
                double baselineHeight = 0.2;
                double heightEffect = (height - baselineHeight) / (1.0 - baselineHeight);
                double temperatureAdjust = heightEffect * 0.4;
                temperature -= temperatureAdjust;
                double effectiveWeather = weather = this.fractal.getWeather(xp, yp, zp);
                if (temperature > 0.857) {
                    double weatherAdjust = (temperature - 0.857) / 0.14300000000000002;
                    weatherAdjust = 1.0 - weatherAdjust;
                    effectiveWeather *= weatherAdjust;
                }
                double ecology = this.fractal.getSoilQuality(xp, yp, zp);
                minTemperature = Math.min(minTemperature, temperature);
                maxTemperature = Math.max(maxTemperature, temperature);
                minWeather = Math.min(minWeather, weather);
                maxWeather = Math.max(maxWeather, weather);
                minEcology = Math.min(minEcology, ecology *= effectiveWeather);
                maxEcology = Math.max(maxEcology, ecology);
            }
        }
        this.updateRanges(minTemperature, minWeather, minEcology);
        this.updateRanges(maxTemperature, maxWeather, maxEcology);
        if (log.isTraceEnabled()) {
            log.trace("Temperature range:" + minTemperature + " -> " + maxTemperature);
            log.trace("Weather range:" + minWeather + " -> " + maxWeather);
            log.trace("Ecolohy range:" + minEcology + " -> " + maxEcology);
            log.trace("Overall Temperature range:" + this.overallMinTemperature + " -> " + this.overallMaxTemperature);
            log.trace("Overall Weather range:" + this.overallMinWeather + " -> " + this.overallMaxWeather);
            log.trace("Overall Ecolohy range:" + this.overallMinEcology + " -> " + this.overallMaxEcology);
        }
        target.getVersion().markChanged();
    }
}

