/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.jme3.renderer.Caps;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.opengl.GL;
import com.jme3.system.JmeContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    static Logger log = LoggerFactory.getLogger(SystemInfo.class);
    private static SystemInfo instance;
    private static final Set<String> sysProps;
    private String buildDate;
    private JmeContext jmeContext;
    private GL gl;
    private Map<String, String> glInfo = new LinkedHashMap<String, String>();
    private Map<String, Object> config;

    private SystemInfo(JmeContext jmeContext, Map<String, Object> config) {
        this.jmeContext = jmeContext;
        this.config = config;
        try {
            URL u = Resources.getResource((String)"mythruna.build.date");
            this.buildDate = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
            log.info("Mythruna build date:" + this.buildDate);
        }
        catch (Exception e) {
            log.error("Error reading mythruna.build.date", (Throwable)e);
        }
        if (jmeContext != null) {
            this.loadGlInfo();
        }
    }

    public static SystemInfo initialize(JmeContext jmeContext, Map<String, Object> config) {
        if (instance == null) {
            instance = new SystemInfo(jmeContext, config);
        }
        return instance;
    }

    public static SystemInfo getInstance() {
        return instance;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) {
        log.info("Writing system info to:" + f);
        try {
            StringWriter sOut = new StringWriter();
            try (PrintWriter out = new PrintWriter(sOut);){
                this.write(out);
            }
            Files.write((CharSequence)sOut.toString(), (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error writing system info:" + f, (Throwable)e);
        }
    }

    public void write(PrintWriter out) {
        out.println("Mythruna Build Date:" + this.buildDate);
        Runtime runtime = Runtime.getRuntime();
        out.println("CPUs:" + runtime.availableProcessors());
        out.println("Max heap:" + runtime.maxMemory());
        out.println("System properties:");
        for (Object object : System.getProperties().keySet()) {
            if (sysProps.contains(object)) {
                out.println("    " + object + ":" + System.getProperty((String)object));
                continue;
            }
            log.info("skipping:" + object + ":" + System.getProperty((String)object));
        }
        if (this.config != null) {
            out.println("Application config:");
            for (Map.Entry entry : this.config.entrySet()) {
                if (((String)entry.getKey()).startsWith("!") || ((String)entry.getKey()).startsWith("//") || ((String)entry.getKey()).startsWith("#") || ((String)entry.getKey()).startsWith("login")) continue;
                out.println("  " + entry);
            }
        }
        out.println("Open GL Info:");
        for (Map.Entry entry : this.glInfo.entrySet()) {
            out.println("    " + (String)entry.getKey() + ":" + (String)entry.getValue());
        }
        if (this.jmeContext != null) {
            out.println("Open GL Caps:");
            for (Caps caps : this.jmeContext.getRenderer().getCaps()) {
                out.println("    " + caps);
            }
        }
    }

    protected void loadGlInfo() {
        try {
            Renderer renderer = this.jmeContext.getRenderer();
            Class c = renderer.getClass();
            Field field = c.getDeclaredField("gl");
            log.info("field:" + field);
            field.setAccessible(true);
            this.gl = (GL)field.get(renderer);
            log.info("gl:" + this.gl);
            EnumSet caps = renderer.getCaps();
            this.glInfo.put("Vendor", this.gl.glGetString(7936));
            this.glInfo.put("Renderer", this.gl.glGetString(7937));
            this.glInfo.put("OpenGL Version", this.gl.glGetString(7938));
            this.glInfo.put("GLSL Version", this.gl.glGetString(35724));
            this.glInfo.put("Profile", caps.contains(Caps.CoreProfile) ? "Core" : "Compatibility");
        }
        catch (Exception e) {
            log.error("Error retrieving GL info", (Throwable)e);
        }
    }

    static {
        sysProps = new HashSet<String>(Arrays.asList("java.runtime.name", "java.vm.version", "java.vm.vendor", "java.vendor.url", "java.vm.name", "sun.java.launcher", "sun.os.patch.level", "java.vm.specification.name", "java.runtime.version", "java.awt.graphicsenv", "os.arch", "java.vm.specification.vendor", "user.variant", "os.name", "org.lwjgl.librarypath", "sun.jnu.encoding", "sun.awt.enableExtraMouseButtons", "java.specification.name", "java.class.version", "sun.management.compiler", "os.version", "java.specification.version", "java.vm.specification.version", "java.home", "sun.arch.data.model", "user.language", "java.specification.vendor", "net.java.games.input.librarypath", "awt.toolkit", "java.vm.info", "java.version", "java.ext.dirs", "java.vendor", "java.vendor.url.bug", "sun.cpu.endian", "sun.desktop"));
    }
}

