/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimPermissions
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ClaimPermissions.class);
    public static final int LOCAL_OVERRIDE = 1;
    public static final int BLOCK_REMOVE = 2;
    public static final int BLOCK_ADD = 4;
    public static final int OBJ_ADD = 8;
    public static final int OBJ_REMOVE = 16;
    public static final int OBJ_MOVE = 32;
    public static final int OBJ_CHANGE = 64;
    public static final int PROP_ADD = 128;
    public static final int PROP_REMOVE = 256;
    public static final int PROP_MOVE = 512;
    public static final int PROP_CHANGE = 1024;
    private EntityId claimId;
    private int perms;

    private ClaimPermissions() {
    }

    public ClaimPermissions(EntityId claimId, int ... permList) {
        this.claimId = claimId;
        this.perms = ClaimPermissions.toPermFlags(permList);
    }

    public static ClaimPermissions createNoAccess(EntityId claimId) {
        return new ClaimPermissions(claimId, new int[0]);
    }

    public static ClaimPermissions createOwnerPermissions(EntityId claimId) {
        return new ClaimPermissions(claimId, 1, 4, 2, 8, 16, 32, 64, 128, 256, 512, 1024);
    }

    public static int toPermFlags(int ... permList) {
        int result = 0;
        for (int i : permList) {
            result |= i;
        }
        return result;
    }

    public EntityId getClaimId() {
        return this.claimId;
    }

    public int getPermissions() {
        return this.perms;
    }

    public boolean canDo(int perm) {
        return (this.perms & perm) != 0;
    }

    public boolean canAddBlock() {
        return (this.perms & 4) != 0;
    }

    public boolean canRemoveBlock() {
        return (this.perms & 2) != 0;
    }

    public boolean canAddObject() {
        return (this.perms & 8) != 0;
    }

    public boolean canRemoveObject() {
        return (this.perms & 0x10) != 0;
    }

    public boolean canMoveObject() {
        return (this.perms & 0x20) != 0;
    }

    public boolean canChangeObject() {
        return (this.perms & 0x40) != 0;
    }

    public int hashCode() {
        return Objects.hash(this.claimId, this.perms);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ClaimPermissions other = (ClaimPermissions)o;
        if (other.perms != this.perms) {
            return false;
        }
        return Objects.equals(other.claimId, this.claimId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[claimId:" + this.claimId + ", perms:0b" + Integer.toBinaryString(this.perms) + "]";
    }
}

