/*
 * Decompiled with CFR 0.152.
 */
package mythruna.item;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySize2d
implements Serializable {
    private static final double HALF_PI = 1.5707963267948966;
    static Logger log = LoggerFactory.getLogger(InventorySize2d.class);
    private int xSlots;
    private int ySlots;
    private double scale;
    private Quatd rotation;
    private Vec3d offset;
    private Vec3d size;

    public InventorySize2d() {
        this(1, 1, 1.0, new Vec3d(1.0, 1.0, 1.0), new Quatd(), new Vec3d());
    }

    public InventorySize2d(int xSlots, int ySlots, double scale, Vec3d size, Quatd rotation, Vec3d offset) {
        this.xSlots = xSlots;
        this.ySlots = ySlots;
        this.scale = scale;
        this.size = size;
        this.rotation = rotation;
        this.offset = offset;
    }

    public int getXSlots() {
        return this.xSlots;
    }

    public int getYSlots() {
        return this.ySlots;
    }

    public double getScale() {
        return this.scale;
    }

    public Vec3d getSize() {
        return this.size;
    }

    public Quatd getRotation() {
        return this.rotation;
    }

    public Vec3d getOffset() {
        return this.offset;
    }

    public static InventorySize2d create(Vec3d min, Vec3d max, double slotSize) {
        double depth;
        double width;
        InventorySize2d result = new InventorySize2d(0, 0, 1.0, max.subtract(min), new Quatd(), min.clone());
        Vec3d size = max.subtract(min);
        int[] axes = InventorySize2d.sortAxes(size);
        if (axes[0] == 1) {
            double height = size.y;
            if (axes[1] == 0) {
                width = size.x;
                depth = size.z;
            } else {
                width = size.z;
                depth = size.x;
                result.rotation.fromAngles(0.0, 1.5707963267948966, 0.0);
            }
        } else if (axes[0] == 2) {
            double height = size.z;
            result.rotation.fromAngles(-1.5707963267948966, Math.PI, 0.0);
            if (axes[1] == 0) {
                width = size.x;
                depth = size.y;
            } else {
                result.rotation = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0).mult(result.rotation);
                width = size.y;
                depth = size.x;
            }
        } else {
            result.rotation.fromAngles(0.0, 0.0, 1.5707963267948966);
            double height = size.x;
            if (axes[1] == 1) {
                width = size.y;
                depth = size.z;
            } else {
                result.rotation = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0).mult(result.rotation);
                width = size.z;
                depth = size.y;
            }
        }
        result.scale = Math.sqrt(depth);
        result.xSlots = Math.max(1, (int)Math.round(width * result.scale / slotSize));
        result.ySlots = Math.max(1, (int)Math.round(depth * result.scale / slotSize));
        return result;
    }

    public static int[] sortAxes(Vec3d size) {
        int[] result = new int[3];
        if (size.x > size.y) {
            if (size.x > size.z) {
                result[0] = 0;
                if (size.y > size.z) {
                    result[1] = 1;
                    result[2] = 2;
                } else {
                    result[1] = 2;
                    result[2] = 1;
                }
            } else {
                result[0] = 2;
                result[1] = 0;
                result[2] = 1;
            }
        } else if (size.y > size.z) {
            result[0] = 1;
            if (size.x > size.z) {
                result[1] = 0;
                result[2] = 2;
            } else {
                result[1] = 2;
                result[2] = 0;
            }
        } else {
            result[0] = 2;
            result[1] = 1;
            result[2] = 0;
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("xSlots", this.xSlots).add("ySlots", this.ySlots).add("scale", this.scale).add("size", (Object)this.size).add("rotation", (Object)this.rotation).add("offset", (Object)this.offset).toString();
    }
}

