/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.filter.Filterd;
import com.simsilica.mathd.filter.SimpleMovingMean;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Bin;
import com.simsilica.mphys.BinIndex;
import com.simsilica.mphys.BinListener;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactAccumulator;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.ContactResolver;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.FilteredContactListener;
import com.simsilica.mphys.HitResults;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.PhysicsFactory;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.PhysicsStats;
import com.simsilica.mphys.QueryFilter;
import com.simsilica.mphys.QueryVolume;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import com.simsilica.mphys.TandemContactResolver;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicsSpace<K, S extends AbstractShape> {
    static Logger log = LoggerFactory.getLogger(PhysicsSpace.class);
    private CollisionSystem<K, S> collisionSystem;
    private ContactAccumulator<K, S> contactAccumulator = new ContactAccumulator();
    private ContactListener<K, S> contactListener = this.contactAccumulator;
    private ContactResolver<K, S> contactResolver = new TandemContactResolver();
    private int activeObjectCount;
    private BinIndex<K, S> binIndex;
    private final DynArray<PhysicsListener<K, S>> listeners = new DynArray(new TypeToken<PhysicsListener<K, S>>(){});
    private boolean tandemJointResolution = false;
    private PhysicsStats stats = new PhysicsStats();
    private PhysicsStats.Stat contactCountStat;
    private PhysicsStats.Stat contactGenTimeStat;
    private PhysicsStats.Stat contactResTimeStat;
    private PhysicsStats.Stat integrationTimeStat;
    private PhysicsStats.Stat driverTimeStat;
    private PhysicsStats.Stat binUpdateTimeStat;
    private PhysicsStats.Stat frameTimeStat;
    private PhysicsStats.Stat binCountStat;
    private PhysicsStats.Stat activeBinCountStat;
    private PhysicsStats.Stat bodyCountStat;
    private PhysicsStats.Stat activeBodyCountStat;
    private boolean collectStats = true;
    private boolean delayedResolve = false;

    public PhysicsSpace(Grid binGrid) {
        this(binGrid, null);
    }

    public PhysicsSpace(Grid binGrid, Vec3i gridRadius) {
        this.binIndex = new BinIndex(binGrid, gridRadius);
        ((TandemContactResolver)this.contactResolver).resolveJoints = this.tandemJointResolution;
        this.contactCountStat = this.stats.getStat("contacts");
        this.contactGenTimeStat = this.stats.getStat("contactGenTime", (Filterd)new SimpleMovingMean(60));
        this.contactResTimeStat = this.stats.getStat("contactResTime", (Filterd)new SimpleMovingMean(60));
        this.integrationTimeStat = this.stats.getStat("integrationTime", (Filterd)new SimpleMovingMean(60));
        this.driverTimeStat = this.stats.getStat("driverTime", (Filterd)new SimpleMovingMean(60));
        this.binUpdateTimeStat = this.stats.getStat("binUpdateTime", (Filterd)new SimpleMovingMean(60));
        this.frameTimeStat = this.stats.getStat("frameTime", (Filterd)new SimpleMovingMean(60));
        this.binCountStat = this.stats.getStat("binCount");
        this.activeBinCountStat = this.stats.getStat("activeBinCount");
        this.bodyCountStat = this.stats.getStat("bodyCount");
        this.activeBodyCountStat = this.stats.getStat("activeBodyCount");
    }

    public void writeDebugInfo(PrintWriter out) {
        out.println("Active object count:" + this.activeObjectCount);
        this.binIndex.writeDebugInfo(out);
    }

    public BinIndex<K, S> getBinIndex() {
        return this.binIndex;
    }

    public Grid getGrid() {
        return this.binIndex.getGrid();
    }

    public void setPhysicsFactory(PhysicsFactory<K, S> factory) {
        this.binIndex.setPhysicsFactory(factory);
    }

    public PhysicsFactory<K, S> getPhysicsFactory() {
        return this.binIndex.getPhysicsFactory();
    }

    public void addBinListener(BinListener<K, S> l) {
        this.binIndex.addBinListener(l);
    }

    public void removeBinListener(BinListener<K, S> l) {
        this.binIndex.removeBinListener(l);
    }

    public void addPhysicsListener(PhysicsListener<K, S> l) {
        this.listeners.add(l);
    }

    public void removePhysicsListener(PhysicsListener<K, S> l) {
        this.listeners.remove(l);
    }

    public void setContactDispatcher(ContactListener<K, S> listener) {
        if (listener == null) {
            this.contactListener = this.contactAccumulator;
            return;
        }
        this.contactListener = new FilteredContactListener<K, S>(listener, this.contactAccumulator);
    }

    public ContactListener<K, S> getContactDispatcher() {
        if (this.contactListener == this.contactAccumulator) {
            return null;
        }
        return ((FilteredContactListener)this.contactListener).getFilter();
    }

    public Bin.Status getBinStatus(GridCell cell) {
        Bin<K, S> bin = this.binIndex.getBin(cell, false);
        if (bin == null) {
            return null;
        }
        return bin.getStatus();
    }

    public final PhysicsStats getStats() {
        return this.stats;
    }

    public final int getActiveObjectCount() {
        return this.activeObjectCount;
    }

    public final int getBinCount() {
        return this.binIndex.size();
    }

    public final int getActiveBinCount() {
        return this.binIndex.getActiveBinCount();
    }

    public final int getActiveJointCount() {
        return this.binIndex.getActiveJointCount();
    }

    public void setCollisionSystem(CollisionSystem<K, S> collisionSystem) {
        this.collisionSystem = collisionSystem;
    }

    public CollisionSystem<K, S> getCollisionSystem() {
        return this.collisionSystem;
    }

    public boolean teleport(K id, Vec3d loc, Quatd orient) {
        return this.binIndex.teleport(id, loc, orient);
    }

    public boolean morph(K id, S shape) {
        return this.binIndex.morph(id, shape);
    }

    public boolean applyImpulse(K id, Vec3d impulse) {
        return this.binIndex.applyImpulse(id, impulse);
    }

    public HitResults<K, S> queryHits(Rayd ray, HitResults<K, S> hits) {
        HashSet<Bin<K, S>> visited = new HashSet<Bin<K, S>>();
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            if (!visited.add(bin)) continue;
            this.collisionSystem.queryBodyHits(ray, bin.getActiveObjects().getArray(), hits);
            this.collisionSystem.queryBodyHits(ray, bin.getInactiveObjects().getArray(), hits);
            this.collisionSystem.queryStaticHits(ray, bin.getStaticObjects().getArray(), hits);
            for (Bin<K, S> neighbor : this.binIndex.getNeighbors(bin)) {
                if (neighbor.getStatus() == Bin.Status.Active || !visited.add(neighbor)) continue;
                this.collisionSystem.queryBodyHits(ray, neighbor.getInactiveObjects().getArray(), hits);
                this.collisionSystem.queryStaticHits(ray, neighbor.getStaticObjects().getArray(), hits);
            }
        }
        return hits;
    }

    public void queryContacts(Vec3d position, Quatd orientation, S shape, QueryFilter<K, S> filter, ContactListener<K, S> results) {
        RigidBody<Object, S> standin = new RigidBody<Object, S>(null, shape, position, orientation);
        if (filter.includeWorld()) {
            this.collisionSystem.generateWorldCollisions(standin, results);
        }
        boolean includeStatic = filter.includeStatic();
        boolean includeInactive = filter.includeInactive();
        boolean includeActive = filter.includeActive();
        Predicate<RigidBody<K, S>> rigidBodyFilter = filter.getRigidBodyFilter();
        Predicate<StaticBody<K, S>> staticBodyFilter = filter.getStaticBodyFilter();
        HashSet<Bin<K, S>> visited = new HashSet<Bin<K, S>>();
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            if (!visited.add(bin)) continue;
            if (includeStatic) {
                this.collisionSystem.generateStaticCollisions(standin, bin.getStaticObjects().getArray(), staticBodyFilter, results);
            }
            if (includeInactive) {
                this.collisionSystem.generateBodyCollisions(standin, bin.getInactiveObjects().getArray(), rigidBodyFilter, results);
            }
            for (Bin<K, S> neighbor : this.binIndex.getNeighbors(bin)) {
                if (neighbor.getStatus() == Bin.Status.Active || !visited.add(neighbor)) continue;
                if (includeStatic) {
                    this.collisionSystem.generateStaticCollisions(standin, neighbor.getStaticObjects().getArray(), staticBodyFilter, results);
                }
                if (!includeInactive) continue;
                this.collisionSystem.generateBodyCollisions(standin, neighbor.getInactiveObjects().getArray(), rigidBodyFilter, results);
            }
            if (!includeActive) continue;
            this.collisionSystem.generateBodyCollisions(standin, bin.getActiveObjects().getArray(), rigidBodyFilter, results);
        }
    }

    public Collection<AbstractBody<K, S>> queryBounds(QueryVolume queryVolume, QueryFilter<K, S> filter) {
        boolean includeStatic = filter.includeStatic();
        boolean includeInactive = filter.includeInactive();
        boolean includeActive = filter.includeActive();
        Predicate<RigidBody<K, S>> rigidBodyFilter = filter.getRigidBodyFilter();
        Predicate<StaticBody<K, S>> staticBodyFilter = filter.getStaticBodyFilter();
        HashSet<AbstractBody<K, S>> results = new HashSet<AbstractBody<K, S>>();
        HashSet<Object> visited = new HashSet<Object>();
        Vec3d temp = new Vec3d();
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            if (!visited.add(bin)) continue;
            if (includeStatic) {
                for (StaticBody<K, S> staticBody : bin.getStaticObjects().getArray()) {
                    if (!staticBodyFilter.apply((Object)staticBody) || !queryVolume.intersects(staticBody.position, staticBody.shape.getBoundsRadius())) continue;
                    results.add(staticBody);
                }
            }
            if (includeInactive) {
                for (RigidBody<K, S> rigidBody : bin.getInactiveObjects().getArray()) {
                    if (!rigidBodyFilter.apply((Object)rigidBody) || !queryVolume.intersects(rigidBody.position, rigidBody.shape.getBoundsRadius())) continue;
                    results.add(rigidBody);
                }
            }
            for (Bin<K, S> bin2 : this.binIndex.getNeighbors(bin)) {
                if (bin2.getStatus() == Bin.Status.Active || !visited.add(bin2)) continue;
                if (includeStatic) {
                    for (AbstractBody abstractBody : bin2.getStaticObjects().getArray()) {
                        if (!staticBodyFilter.apply((Object)abstractBody) || !queryVolume.intersects(((StaticBody)abstractBody).position, ((StaticBody)abstractBody).shape.getBoundsRadius())) continue;
                        results.add(abstractBody);
                    }
                }
                if (!includeInactive) continue;
                for (AbstractBody abstractBody : bin2.getInactiveObjects().getArray()) {
                    if (!rigidBodyFilter.apply((Object)abstractBody) || !queryVolume.intersects(((RigidBody)abstractBody).position, ((RigidBody)abstractBody).shape.getBoundsRadius())) continue;
                    results.add(abstractBody);
                }
            }
            if (!includeActive) continue;
            for (RigidBody<K, S> rigidBody : bin.getActiveObjects().getArray()) {
                if (!rigidBodyFilter.apply((Object)rigidBody) || !queryVolume.intersects(rigidBody.position, rigidBody.shape.getBoundsRadius())) continue;
                results.add(rigidBody);
            }
        }
        return results;
    }

    protected void activate(RigidBody<K, S> body) {
        this.binIndex.activate(body);
    }

    protected void deactivate(RigidBody<K, S> body) {
        this.binIndex.deactivate(body);
    }

    protected final void fireStartFrame(long frameTime, double step) {
        for (PhysicsListener<K, S> l : this.listeners.getArray()) {
            l.startFrame(frameTime, step);
        }
    }

    protected final void fireAfterIntegrate(long frameTime, double step) {
        for (PhysicsListener<K, S> l : this.listeners.getArray()) {
            l.afterIntegrate(frameTime, step);
        }
    }

    protected final void fireEndFrame() {
        for (PhysicsListener<K, S> l : this.listeners.getArray()) {
            l.endFrame();
        }
    }

    protected final void fireObjectUpdate(RigidBody<K, S> body) {
        for (PhysicsListener<K, S> l : this.listeners.getArray()) {
            l.update(body);
        }
    }

    public void integrate(long frameTime, double step) {
        if (this.collectStats) {
            long start = System.nanoTime();
            this.doIntegrate(frameTime, step);
            long end = System.nanoTime();
            this.frameTimeStat.updateValue(end - start);
            this.binCountStat.updateValue(this.binIndex.size());
            this.activeBinCountStat.updateValue(this.binIndex.getActiveBinCount());
            this.bodyCountStat.updateValue(this.binIndex.getRigidBodyCount());
            this.activeBodyCountStat.updateValue(this.activeObjectCount);
        } else {
            this.doIntegrate(frameTime, step);
        }
    }

    private void doIntegrate(long frameTime, double step) {
        this.fireStartFrame(frameTime, step);
        if (this.delayedResolve) {
            this.reactivateObjects();
            this.resolveContacts(step);
        }
        if (this.binIndex.getActiveBinCount() == 0) {
            this.binIndex.flushPending();
            this.fireEndFrame();
            return;
        }
        long start1 = System.nanoTime();
        long driverTime = 0L;
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            for (RigidBody<K, S> body : bin.getActiveObjects().getArray()) {
                long s = System.nanoTime();
                body.updateDriver(frameTime, step);
                long e = System.nanoTime();
                if (this.collectStats) {
                    driverTime += e - s;
                }
                body.integrate(step);
            }
        }
        if (this.collectStats) {
            this.integrationTimeStat.updateValue(System.nanoTime() - start1);
            this.driverTimeStat.updateValue(driverTime);
        }
        if (!this.tandemJointResolution) {
            this.resolveJoints(step);
        }
        this.fireAfterIntegrate(frameTime, step);
        this.generateContacts();
        if (!this.delayedResolve) {
            this.reactivateObjects();
            this.resolveContacts(step);
        }
        long start2 = System.nanoTime();
        this.activeObjectCount = 0;
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            for (RigidBody<K, S> body : bin.getActiveObjects().getArray()) {
                if (body.lastUpdateFrame == frameTime) continue;
                body.lastUpdateFrame = frameTime;
                this.binIndex.update(body);
                ++this.activeObjectCount;
                this.fireObjectUpdate(body);
                if (!body.isSleepy()) continue;
                this.deactivate(body);
                --this.activeObjectCount;
            }
        }
        if (this.collectStats) {
            this.binUpdateTimeStat.updateValue(System.nanoTime() - start2);
        }
        this.fireEndFrame();
        this.binIndex.flushPending();
    }

    protected void generateContacts() {
        this.contactAccumulator.clear();
        long start = System.nanoTime();
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            for (RigidBody<K, S> body : bin.getActiveObjects().getArray()) {
                this.collisionSystem.generateWorldCollisions(body, this.contactListener);
                this.collisionSystem.generateStaticCollisions(body, bin.getStaticObjects().getArray(), this.contactListener);
                this.collisionSystem.generateBodyCollisions(body, bin.getInactiveObjects().getArray(), this.contactListener);
                for (Bin<K, S> neighbor : this.binIndex.getNeighbors(bin)) {
                    this.collisionSystem.generateStaticCollisions(body, neighbor.getStaticObjects().getArray(), this.contactListener);
                    this.collisionSystem.generateBodyCollisions(body, neighbor.getInactiveObjects().getArray(), this.contactListener);
                }
            }
        }
        HashSet<Bin<K, S>> visited = new HashSet<Bin<K, S>>();
        for (Bin<K, S> bin : this.binIndex.getActiveBins()) {
            this.collisionSystem.generateBodyCollisions(bin.getActiveObjects().getArray(), this.contactListener);
            Bin<K, S>[] neighbors = this.binIndex.getNeighbors(bin);
            for (RigidBody<K, S> body : bin.getActiveObjects().getArray()) {
                for (Bin<K, S> neighbor : neighbors) {
                    if (neighbor.getStatus() != Bin.Status.Active || visited.contains(neighbor)) continue;
                    this.collisionSystem.generateBodyCollisions(body, neighbor.getActiveObjects().getArray(), this.contactListener);
                }
            }
            visited.add(bin);
        }
        if (this.collectStats) {
            long delta = System.nanoTime() - start;
            this.contactCountStat.updateValue(this.contactAccumulator.contacts.size());
            this.contactGenTimeStat.updateValue(delta);
        }
    }

    protected void reactivateObjects() {
        for (Contact c : this.contactAccumulator.contacts) {
            double temp;
            if (c.getBody2() == null || RigidBody.isCold(temp = c.calculateContactTemperature())) continue;
            if (c.body1.isSleepy()) {
                this.activate(c.body1);
            }
            if (!c.getBody2().isSleepy()) continue;
            this.activate(c.getBody2());
        }
        if (this.tandemJointResolution) {
            for (Joint<K, S> joint : this.binIndex.getActiveJoints().getArray()) {
                if (joint.isSleepy()) continue;
                if (joint.getMainBody().isSleepy()) {
                    this.activate(joint.getMainBody());
                }
                if (joint.getAltBody() == null || !joint.getAltBody().isSleepy()) continue;
                this.activate(joint.getAltBody());
            }
        }
    }

    protected void resolveContacts(double step) {
        if (this.collectStats) {
            long start = System.nanoTime();
            this.contactResolver.resolveContacts(this.contactAccumulator.contacts, this.binIndex.getActiveJoints(), step);
            long end = System.nanoTime();
            this.contactResTimeStat.updateValue(end - start);
        } else {
            this.contactResolver.resolveContacts(this.contactAccumulator.contacts, this.binIndex.getActiveJoints(), step);
        }
    }

    protected void resolveJoints(double step) {
        for (Joint<K, S> joint : this.binIndex.getActiveJoints().getArray()) {
            if (joint.isSleepy()) continue;
            if (joint.getMainBody().isSleepy()) {
                this.activate(joint.getMainBody());
            }
            if (joint.getAltBody() != null && joint.getAltBody().isSleepy()) {
                this.activate(joint.getAltBody());
            }
            joint.resolve(step);
        }
    }
}

