/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.grid;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.grid.GridModel;

public class ArrayGridModel<T>
implements GridModel<T> {
    private T[][] array;
    private int rows;
    private int cols;
    private long version;

    public ArrayGridModel(T[][] array) {
        this.array = array;
        this.rows = array.length;
        if (this.rows > 0) {
            this.cols = array[0].length;
        }
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.cols;
    }

    @Override
    public T getCell(int row, int col, T existing) {
        return this.array[row][col];
    }

    @Override
    public void setCell(int row, int col, T value) {
        this.array[row][col] = value;
        this.incrementVersion();
    }

    protected void incrementVersion() {
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public GridModel<T> getObject() {
        return this;
    }

    public VersionedReference<GridModel<T>> createReference() {
        return new VersionedReference((VersionedObject)this);
    }
}

