/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import mythruna.client.view.object.AbstractModel;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelFactory;
import mythruna.client.view.object.SpatialCache;
import mythruna.client.view.object.SpatialFactory;
import mythruna.client.view.object.SpatialUtils;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelFactory
implements ModelFactory {
    static Logger log = LoggerFactory.getLogger(DefaultModelFactory.class);
    private SpatialCache cache;
    private JobState workers;

    public DefaultModelFactory(ShapeFactory<MBlockShape> shapeFactory, SpatialFactory spatialFactory, JobState workers) {
        this.cache = new SpatialCache(shapeFactory, spatialFactory);
        this.workers = workers;
    }

    @Override
    public Model createModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
        SpatialModel result = new SpatialModel(this, entityId, name, shapeInfo);
        this.workers.execute((Job)new ModelLoader(result, name, shapeInfo), -1);
        return result;
    }

    protected class SpatialModel
    extends AbstractModel {
        private ColorRGBA localLighting = new ColorRGBA();
        private Vec3d center = new Vec3d();

        public SpatialModel(DefaultModelFactory this$0, EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
            super(entityId, name, shapeInfo);
        }

        @Override
        protected void updateSpatial(Spatial spatial) {
            super.updateSpatial(spatial);
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "LocalLighting", (Object)this.localLighting));
            spatial.setCullHint(Spatial.CullHint.Always);
        }

        @Override
        public void setLighting(int lighting) {
            float s = (float)LightUtils.sun((int)lighting) / 15.0f;
            float r = (float)LightUtils.red((int)lighting) / 15.0f;
            float g = (float)LightUtils.green((int)lighting) / 15.0f;
            float b = (float)LightUtils.blue((int)lighting) / 15.0f;
            this.localLighting.set(r, g, b, s);
        }

        @Override
        public Vec3d getCenterOffset() {
            Spatial spatial = (Spatial)this.getSpatialHolder().getObject();
            if (spatial == null) {
                return this.center;
            }
            this.center.set(spatial.getWorldBound().getCenter());
            this.center.subtractLocal(new Vec3d(spatial.getWorldTranslation()));
            return this.center;
        }
    }

    protected class ModelLoader
    implements Job {
        private final SpatialModel target;
        private final ShapeName name;
        private final ShapeInfo shapeInfo;
        private Spatial spatial;

        public ModelLoader(SpatialModel target, ShapeName name, ShapeInfo shapeInfo) {
            this.target = target;
            this.name = name;
            this.shapeInfo = shapeInfo;
        }

        public void runOnWorker() {
            try {
                this.spatial = DefaultModelFactory.this.cache.createSpatial(this.name.getFullName(), this.shapeInfo.getScale());
            }
            catch (Exception e) {
                log.error("Error loading:" + this.name + " for:" + this.target, (Throwable)e);
                this.spatial = SpatialUtils.createDebugSphere("bad:" + this.target.getEntityId(), (float)this.shapeInfo.getScale(), ColorRGBA.Red, null);
            }
            this.spatial.setUserData("oid", (Object)this.target.getEntityId().getId());
        }

        public double runOnUpdate() {
            this.target.updateSpatial(this.spatial);
            return 0.1;
        }
    }
}

