/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import java.util.List;

public class CurveAndSurfaceMath {
    private static final float KNOTS_MINIMUM_DELTA = 1.0E-4f;

    private CurveAndSurfaceMath() {
    }

    public static void interpolateNurbs(float u, Spline nurbSpline, Vector3f store) {
        if (nurbSpline.getType() != Spline.SplineType.Nurb) {
            throw new IllegalArgumentException("Given spline is not of a NURB type!");
        }
        List<Vector3f> controlPoints = nurbSpline.getControlPoints();
        float[] weights = nurbSpline.getWeights();
        List<Float> knots = nurbSpline.getKnots();
        int controlPointAmount = controlPoints.size();
        store.set(Vector3f.ZERO);
        float delimiter = 0.0f;
        for (int i = 0; i < controlPointAmount; ++i) {
            float val = weights[i] * CurveAndSurfaceMath.computeBaseFunctionValue(i, nurbSpline.getBasisFunctionDegree(), u, knots);
            store.addLocal(nurbSpline.getControlPoints().get(i).mult(val));
            delimiter += val;
        }
        store.divideLocal(delimiter);
    }

    public static void interpolate(float u, float v, List<List<Vector4f>> controlPoints, List<Float>[] knots, int basisUFunctionDegree, int basisVFunctionDegree, Vector3f store) {
        store.set(Vector3f.ZERO);
        float delimiter = 0.0f;
        int vControlPointsAmount = controlPoints.size();
        int uControlPointsAmount = controlPoints.get(0).size();
        for (int i = 0; i < vControlPointsAmount; ++i) {
            for (int j = 0; j < uControlPointsAmount; ++j) {
                Vector4f controlPoint = controlPoints.get(i).get(j);
                float val = controlPoint.w * CurveAndSurfaceMath.computeBaseFunctionValue(i, basisVFunctionDegree, v, knots[1]) * CurveAndSurfaceMath.computeBaseFunctionValue(j, basisUFunctionDegree, u, knots[0]);
                store.addLocal(controlPoint.x * val, controlPoint.y * val, controlPoint.z * val);
                delimiter += val;
            }
        }
        store.divideLocal(delimiter);
    }

    public static void prepareNurbsKnots(List<Float> knots, int basisFunctionDegree) {
        float delta = 1.0E-4f;
        float prevValue = knots.get(0).floatValue();
        for (int i = 1; i < knots.size(); ++i) {
            float value = knots.get(i).floatValue();
            if (value <= prevValue) {
                knots.set(i, Float.valueOf(value += delta));
                delta += 1.0E-4f;
            } else {
                delta = 1.0E-4f;
            }
            prevValue = value;
        }
    }

    private static float computeBaseFunctionValue(int i, int k, float t, List<Float> knots) {
        if (k == 1) {
            return knots.get(i).floatValue() <= t && t < knots.get(i + 1).floatValue() ? 1.0f : 0.0f;
        }
        return (t - knots.get(i).floatValue()) / (knots.get(i + k - 1).floatValue() - knots.get(i).floatValue()) * CurveAndSurfaceMath.computeBaseFunctionValue(i, k - 1, t, knots) + (knots.get(i + k).floatValue() - t) / (knots.get(i + k).floatValue() - knots.get(i + 1).floatValue()) * CurveAndSurfaceMath.computeBaseFunctionValue(i + 1, k - 1, t, knots);
    }
}

