/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class IndexShortBuffer
extends IndexBuffer {
    private final ShortBuffer buf;
    private int maxValue = 65535;

    public IndexShortBuffer(ShortBuffer buffer) {
        this.buf = buffer;
        this.buf.rewind();
    }

    public IndexShortBuffer(ShortBuffer buffer, int maxValue) {
        assert (maxValue >= 0 && maxValue <= 65535) : "out of range: " + maxValue;
        this.maxValue = maxValue;
        this.buf = buffer;
        this.buf.rewind();
    }

    @Override
    public int get() {
        return this.buf.get() & 0xFFFF;
    }

    @Override
    public int get(int i) {
        return this.buf.get(i) & 0xFFFF;
    }

    @Override
    public IndexShortBuffer put(int i, int value) {
        assert (value >= 0 && value <= this.maxValue) : "IndexBuffer was created with elements too small for value=" + value;
        this.buf.put(i, (short)value);
        return this;
    }

    @Override
    public IndexShortBuffer put(int value) {
        assert (value >= 0 && value <= this.maxValue) : "IndexBuffer was created with elements too small for value=" + value;
        this.buf.put((short)value);
        return this;
    }

    @Override
    public int size() {
        return this.buf.limit();
    }

    @Override
    public Buffer getBuffer() {
        return this.buf;
    }

    @Override
    public VertexBuffer.Format getFormat() {
        return VertexBuffer.Format.UnsignedShort;
    }
}

