/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.google.common.base.Supplier;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.base.DefaultServer;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.kernel.tcp.SelectorKernel;
import com.jme3.network.kernel.udp.UdpKernel;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.ArraySerializer;
import com.jme3.network.serializing.serializers.EnumSerializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rpc.RpcHostedService;
import com.simsilica.account.AccountManager;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectAction;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.bpos.mphys.BodyPositionPublisher;
import com.simsilica.bpos.mphys.LargeGridIndexSystem;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.es.MixConfig;
import com.simsilica.crig.sim.CharacterAnimationSystem;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.EntityUpdater;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ethereal.NetworkStateListener;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.event.ErrorEvent;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.ext.mphys.net.ZoneNetworkSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mworld.World;
import com.simsilica.mworld.net.server.WorldHostedService;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameLoop;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.LoopSleepStrategy;
import com.simsilica.sim.NanoLoopSleepStrategy;
import com.simsilica.sim.RecurringTaskSystem;
import com.simsilica.sim.SystemTiming;
import com.simsilica.sim.common.DecaySystem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mythruna.GameConstants;
import mythruna.assembly.db.SubassemblyStorage;
import mythruna.character.BodyConfigIndex;
import mythruna.character.PronounsIndex;
import mythruna.character.RaceTypeIndex;
import mythruna.cmd.CommandSystem;
import mythruna.es.ChildOf;
import mythruna.es.ClientComponents;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.PortalLink;
import mythruna.es.StructureInfo;
import mythruna.es.VisionEffect;
import mythruna.item.ItemSizeHandler;
import mythruna.net.LagSimulator;
import mythruna.net.server.AccountHostedService;
import mythruna.net.server.CharacterHostedService;
import mythruna.net.server.DataSessionHostedService;
import mythruna.net.server.DestructibleSessionHostedService;
import mythruna.net.server.GameSessionHostedService;
import mythruna.server.PrebuiltObjectSetup;
import mythruna.server.ServerModsSystem;
import mythruna.shape.ShapeRegistryBuilder;
import mythruna.shell.CommandShell;
import mythruna.shell.Echo;
import mythruna.shell.Help;
import mythruna.shell.Say;
import mythruna.shell.ShellCommand;
import mythruna.shell.ShellService;
import mythruna.sim.AppearanceSystem;
import mythruna.sim.AttachmentSystem;
import mythruna.sim.ContactSystem;
import mythruna.sim.DestructibleObjectSystem;
import mythruna.sim.GameActionSystem;
import mythruna.sim.HoldingSystem;
import mythruna.sim.MorphAnimationSystem;
import mythruna.sim.MorphSystem;
import mythruna.sim.MovementSystem;
import mythruna.sim.PathRecorderSystem;
import mythruna.sim.TemporaryObjectSystem;
import mythruna.sim.ThreadPoolSystem;
import mythruna.sim.WorldTimeService;
import mythruna.sim.ai.AgentActivationSystem;
import mythruna.sim.ai.AgentSystem;
import mythruna.sim.ai.MobEncounterSystem;
import mythruna.sim.encounter.CellStatsInitializer;
import mythruna.sim.encounter.EncounterSystem;
import mythruna.sim.time.SchedulingSystem;
import mythruna.sim.time.WorldTimeSettingsSystem;
import mythruna.sim.trigger.TriggerActionSystem;
import mythruna.sim.trigger.TriggerSystem;
import mythruna.sim.world.WorldStats;
import mythruna.world.WorldManager;
import mythruna.world.WorldTime;
import mythruna.world.WorldTimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameServer {
    static Logger log = LoggerFactory.getLogger(GameServer.class);
    private WorldManager worldManager;
    private String description;
    private Server server;
    private GameSystemManager systems;
    private GameLoop loop;
    private CommandShell adminShell;
    private File modRoot = new File("server-mods");
    private Supplier<String> tokenSupplier;

    public GameServer(WorldManager worldManager, Supplier<String> tokenSupplier, InetAddress hostAddress, int port, String description, Map<String, Object> startupSettings) throws IOException {
        this.worldManager = worldManager;
        this.description = description;
        this.tokenSupplier = tokenSupplier;
        if (startupSettings.get("modRoot") != null) {
            this.modRoot = new File((String)startupSettings.get("modRoot"));
            if (!this.modRoot.exists()) {
                throw new IllegalArgumentException("Specified mod-root does not exist:" + this.modRoot);
            }
        }
        if (worldManager.getInfo().getSpawnPoint() == null) {
            log.error("World has no spawn point:" + worldManager.getInfo());
        }
        Serializer.initialize();
        this.systems = new GameSystemManager();
        this.loop = new GameLoop(this.systems);
        this.loop.setPriority(Integer.valueOf(10));
        if (Boolean.TRUE.equals(startupSettings.get("useNanoSleep"))) {
            log.info("Using: NanoLoopSleepStrategy");
            this.loop.setLoopSleepStrategy((LoopSleepStrategy)new NanoLoopSleepStrategy());
        }
        this.systems.register(ThreadPoolSystem.class, (Object)new ThreadPoolSystem("gs-workers", 4, 1000));
        this.systems.register(WorldManager.class, (Object)worldManager);
        this.systems.register(RecurringTaskSystem.class, (Object)new RecurringTaskSystem());
        ObservableEntityData ed = worldManager.getEntityData();
        this.systems.register(EntityData.class, (Object)ed);
        Number tcpLag = (Number)startupSettings.get("SimulatedServerLag.TCP");
        if (tcpLag == null || tcpLag.longValue() == 0L) {
            this.server = Network.createServer((String)"Mythruna", (int)20250122, (int)port, (int)port);
        } else {
            log.info("Simulating TCP lag:" + tcpLag.longValue());
            final LagSimulator lagSim = new LagSimulator("server", tcpLag.longValue());
            UdpKernel fast = new UdpKernel(port);
            SelectorKernel reliable = new SelectorKernel(port);
            this.server = new DefaultServer(this, "Mythruna", 20250122, (Kernel)reliable, (Kernel)fast){

                public void close() {
                    lagSim.close();
                    super.close();
                }

                protected void dispatch(HostedConnection source, Message m) {
                    if (m.isReliable()) {
                        lagSim.run(() -> super.dispatch(source, m));
                    } else {
                        super.dispatch(source, m);
                    }
                }
            };
        }
        this.server.addChannel(port + 0 + 1);
        this.server.addChannel(port + 1 + 1);
        this.server.addChannel(port + 2 + 1);
        this.server.addChannel(port + 3 + 1);
        HostedService[] hostedServiceArray = new HostedService[7];
        hostedServiceArray[0] = new RpcHostedService();
        hostedServiceArray[1] = new RmiHostedService();
        hostedServiceArray[2] = new EntityDataHostedService(1, ed);
        DataSessionHostedService dataService = new DataSessionHostedService(this.systems, worldManager.getTextDb(), 2);
        hostedServiceArray[3] = dataService;
        hostedServiceArray[4] = new DestructibleSessionHostedService(this.systems, 3);
        hostedServiceArray[5] = new ChatHostedService(0);
        hostedServiceArray[6] = new GameSessionHostedService(this.systems);
        this.server.getServices().addServices(hostedServiceArray);
        dataService.registerDataRequestHandler("itemSize", (Function)new ItemSizeHandler((EntityData)ed));
        EtherealHost ethereal = new EtherealHost(GameConstants.OBJECT_PROTOCOL, GameConstants.ZONE_GRID, GameConstants.ZONE_RADIUS);
        ethereal.getZones().setSupportLargeObjects(true);
        ethereal.setTimeSource(new TimeSource(){

            public long getTime() {
                return GameServer.this.systems.getStepTime().getUnlockedTime(System.nanoTime());
            }
        });
        this.server.getServices().addService((HostedService)ethereal);
        World world = worldManager.getWorld();
        this.systems.register(World.class, (Object)world);
        this.server.getServices().addService((HostedService)new WorldHostedService(world, 2));
        this.systems.register(WorldStats.class, (Object)new WorldStats());
        this.systems.register(CellArrayStorage.class, (Object)worldManager.getCellArrayStorage());
        this.systems.register(SubassemblyStorage.class, (Object)worldManager.getSubassemblyStorage());
        this.systems.addSystem((GameSystem)new LargeGridIndexSystem(GameConstants.LARGE_OBJECT_GRID));
        this.systems.addSystem((GameSystem)new EntityUpdater((EntityDataHostedService)this.server.getServices().getService(EntityDataHostedService.class), true));
        this.systems.addSystem((GameSystem)new DecaySystem());
        WorldTimeService timeService = new WorldTimeService();
        this.systems.register(WorldTimeSource.class, (Object)timeService);
        this.systems.register(WorldTimeService.class, (Object)timeService);
        this.systems.register(WorldTime.class, (Object)timeService.getWorldTime());
        GameActionSystem gameActions = new GameActionSystem();
        this.systems.register(GameActionSystem.class, (Object)gameActions);
        this.systems.register(SchedulingSystem.class, (Object)new SchedulingSystem());
        worldManager.setEntityInitializer(initId -> gameActions.spoolAction(initId, "initialize", new Object[0]));
        ShapeFactoryRegistry shapeFactory = ShapeRegistryBuilder.serverRegistry((WorldManager)worldManager);
        this.systems.register(ShapeFactory.class, (Object)shapeFactory);
        EntityBodyFactory bodyFactory = new EntityBodyFactory((EntityData)ed, GameConstants.DEFAULT_GRAVITY, (ShapeFactory)shapeFactory);
        bodyFactory.setErrorFactory((name, scale, mass) -> {
            if (mass != null) {
                return MBlockShape.createSphere((double)1.0, (double)mass.getMass());
            }
            return MBlockShape.createSphere((double)1.0, (double)0.0);
        });
        MPhysSystem mphys = new MPhysSystem(GameConstants.PHYSICS_GRID, GameConstants.PHYSICS_GRID_RADIUS, bodyFactory);
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        MBlockCollisionSystem collisionSystem = new MBlockCollisionSystem(worldManager.getPhysicalWorld(), colliders);
        mphys.setCollisionSystem((CollisionSystem)collisionSystem);
        this.systems.register(MPhysSystem.class, (Object)mphys);
        this.systems.register(PhysicsSpace.class, (Object)mphys.getPhysicsSpace());
        this.systems.register(EntityBodyFactory.class, (Object)bodyFactory);
        this.systems.register(ContactSystem.class, (Object)new ContactSystem());
        this.systems.register(DestructibleObjectSystem.class, (Object)new DestructibleObjectSystem());
        this.systems.register(ZoneNetworkSystem.class, (Object)new ZoneNetworkSystem(ethereal.getZones()));
        this.systems.addSystem((GameSystem)new BodyPositionPublisher());
        this.systems.register(MovementSystem.class, (Object)new MovementSystem());
        this.systems.register(AgentSystem.class, (Object)new AgentSystem((ChatHostedService)this.server.getServices().getService(ChatHostedService.class)));
        this.systems.register(AgentActivationSystem.class, (Object)new AgentActivationSystem());
        this.systems.register(MobEncounterSystem.class, (Object)new MobEncounterSystem());
        this.systems.register(CharacterAnimationSystem.class, (Object)new CharacterAnimationSystem());
        this.systems.register(AttachmentSystem.class, (Object)new AttachmentSystem());
        this.systems.register(MorphAnimationSystem.class, (Object)new MorphAnimationSystem());
        this.systems.register(MorphSystem.class, (Object)new MorphSystem());
        this.systems.register(PathRecorderSystem.class, (Object)new PathRecorderSystem());
        this.systems.register(HoldingSystem.class, (Object)new HoldingSystem());
        this.systems.register(RaceTypeIndex.class, (Object)RaceTypeIndex.create(id -> worldManager.getTextDb().getText(id, null), (boolean)false));
        this.systems.register(BodyConfigIndex.class, (Object)BodyConfigIndex.create(id -> worldManager.getTextDb().getText(id, null)));
        this.systems.register(PronounsIndex.class, (Object)PronounsIndex.create(id -> worldManager.getTextDb().getText(id, null)));
        this.systems.register(AppearanceSystem.class, (Object)new AppearanceSystem());
        this.systems.register(TriggerSystem.class, (Object)new TriggerSystem());
        this.systems.register(TriggerActionSystem.class, (Object)new TriggerActionSystem(((GameSessionHostedService)this.server.getServices().getService(GameSessionHostedService.class)).getPlayerEnvs()));
        WorldTimeSettingsSystem timeSettings = new WorldTimeSettingsSystem();
        this.systems.register(WorldTimeSettingsSystem.class, (Object)timeSettings);
        EncounterSystem encounters = new EncounterSystem();
        this.systems.register(EncounterSystem.class, (Object)encounters);
        encounters.addZoneInitializer((Consumer)new CellStatsInitializer(world));
        ObjectTypeRegistry objectTypes = new ObjectTypeRegistry().typeNameResolver(id -> {
            ObjectTypeInfo typeInfo = (ObjectTypeInfo)ed.getComponent(id, ObjectTypeInfo.class);
            if (log.isTraceEnabled()) {
                String name = typeInfo == null ? null : typeInfo.getTypeName((EntityData)ed);
                log.trace("typeNameResolver() type:" + name);
            }
            return typeInfo == null ? null : typeInfo.getTypeName((EntityData)ed);
        });
        this.systems.register(ObjectTypeRegistry.class, (Object)objectTypes);
        objectTypes.setDefaultType(new ObjectType("Default", new ObjectAction[0]));
        this.registerSerializers();
        PrebuiltObjectSetup.setupTypes(this.systems);
        this.systems.register(TemporaryObjectSystem.class, (Object)new TemporaryObjectSystem());
        ActionEnvironment serverEnv = new ActionEnvironment(objectTypes, null);
        this.systems.register(ShellService.class, (Object)new ShellService(serverEnv));
        this.setupShell((ShellService)this.systems.get(ShellService.class), tokenSupplier != null);
        this.systems.register(CommandSystem.class, (Object)new CommandSystem());
        this.setupAdminShell(serverEnv);
        worldManager.getModManager().loadFromResource("/mythruna/server/marks-api.json");
        worldManager.getModManager().loadFromResource("/mythruna/server/server-admin.json");
        worldManager.getModManager().loadFromResource("/mythruna/server/stats.mod.json");
        worldManager.getModManager().loadFromResource("/mythruna/server/preload.mod.json");
        worldManager.getModManager().loadFromResource("/mythruna/logging/server-log.json");
        worldManager.getModManager().setGlobalBinding("gameSystems", (Object)this.systems);
        worldManager.getModManager().setGlobalBinding("server", (Object)this);
        ServerModsSystem modFiles = new ServerModsSystem(worldManager.getModManager(), 1.0);
        modFiles.loadModFiles(this.modRoot);
        this.systems.register(ServerModsSystem.class, (Object)modFiles);
        this.server.getServices().addService((HostedService)new CharacterHostedService(this.systems));
        SystemTiming timing = new SystemTiming();
        timing.setTimingCheckThreshold(50L);
        this.systems.setSystemTiming(timing);
    }

    protected void registerSerializers() {
        Serializer.registerClass(Quatd.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Vec3d.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Vec3i.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Name.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(SpawnPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(BodyPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ShapeInfo.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Mass.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Array.newInstance(EntityComponent.class, 0).getClass(), (Serializer)new ArraySerializer());
        Serializer.registerClass(LargeObject.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LargeGridCell.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LayerConfig.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(MixConfig.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(AnimationConfig.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Option.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(PromptType.class, (Serializer)new EnumSerializer());
        Serializer.registerClass(VisionEffect.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(PortalLink.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ChildOf.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(StructureInfo.class, (Serializer)new FieldSerializer());
        ClientComponents.registerSerializers();
    }

    protected void setupShell(ShellService shellService, boolean singlePlayer) {
        CommandShell global = shellService.getGlobalShell();
        global.addCommand("help", (ShellCommand)new Help());
        if (singlePlayer) {
            global.addCommand("echo", (ShellCommand)new Echo());
        }
        global.put("systems", (Object)this.systems);
    }

    protected void setupAdminShell(ActionEnvironment<?, EntityId> globalEnv) {
        this.adminShell = ((ShellService)this.systems.get(ShellService.class)).createChildShell((Object)this.worldManager.getWorldEntity(), globalEnv);
        ChatHostedService chat = (ChatHostedService)this.server.getServices().getService(ChatHostedService.class);
        Say say = new Say(text -> chat.postMessage(-1, "<admin-console>", text));
        this.adminShell.addCommand("say", (ShellCommand)say);
        this.adminShell.addCommand("'", (ShellCommand)say);
    }

    public Server getServer() {
        return this.server;
    }

    public GameSystemManager getSystems() {
        return this.systems;
    }

    public CommandShell getAdminShell() {
        return this.adminShell;
    }

    protected void setupConfigurableServices() {
        EntityData ed = (EntityData)this.systems.get(EntityData.class, true);
        AccountManager acctMgr = (AccountManager)this.systems.get(AccountManager.class);
        if (acctMgr != null) {
            this.server.getServices().addService((HostedService)new AccountHostedService(this.worldManager, ed, acctMgr));
        } else if (this.tokenSupplier != null) {
            this.server.getServices().addService((HostedService)new AccountHostedService(this.worldManager, ed, this.tokenSupplier));
        } else if (this.tokenSupplier == null) {
            throw new RuntimeException("No account manager defined, no token supplier defined.");
        }
    }

    public void start() {
        try {
            log.info("Initializing MOD manager...");
            this.worldManager.getModManager().initialize();
        }
        catch (Exception e) {
            log.error("Error initializing mod-manager", (Throwable)e);
            EventBus.publish((EventType)ErrorEvent.fatalError, (Object)new ErrorEvent((Throwable)e));
        }
        this.setupConfigurableServices();
        log.info("Starting game server...");
        this.server.start();
        this.loop.start(true);
        log.info("Game server started.");
    }

    public void close(String kickMessage) {
        log.info("Stopping game server..." + kickMessage);
        this.loop.stop();
        if (kickMessage != null) {
            for (HostedConnection conn : this.server.getConnections()) {
                conn.close(kickMessage);
            }
        }
        this.server.close();
        this.worldManager.getModManager().terminate();
        if (this.systems.isInitialized()) {
            this.systems.stop();
            this.systems.terminate();
        }
        log.info("Game server stopped.");
    }

    public void close() {
        this.close(null);
    }

    public void logStats() {
        EtherealHost host = (EtherealHost)this.server.getServices().getService(EtherealHost.class);
        for (HostedConnection conn : this.server.getConnections()) {
            log.info("Client[" + conn.getId() + "] address:" + conn.getAddress());
            NetworkStateListener listener = host.getStateListener(conn);
            if (listener == null) {
                log.info("[" + conn.getId() + "] No stats");
                continue;
            }
            log.info("[" + conn.getId() + "] Ping time: " + (double)listener.getConnectionStats().getAveragePingTime() / 1000000.0 + " ms");
            String miss = String.format("%.02f", listener.getConnectionStats().getAckMissPercent());
            log.info("[" + conn.getId() + "] Ack miss: " + miss + "%");
            log.info("[" + conn.getId() + "] Average msg size: " + listener.getConnectionStats().getAverageMessageSize() + " bytes");
        }
    }
}

