/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mythruna.character.HairTone;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HairToneIndex {
    static Logger log = LoggerFactory.getLogger(HairToneIndex.class);
    public static final String SKIN_TONE_INDEX_CSV = "races/hair-colors.csv";
    private List<HairTone> allTones = new ArrayList<HairTone>();
    private ListMultimap<String, HairTone> raceIndex = MultimapBuilder.hashKeys().arrayListValues().build();

    public HairToneIndex(List<HairTone> tones) {
        this.allTones = tones;
        for (HairTone tone : tones) {
            for (String race : tone.getRaces()) {
                this.raceIndex.put((Object)race, (Object)tone);
            }
        }
    }

    public List<HairTone> getTones() {
        return this.allTones;
    }

    public HairTone getRandomTone(String race, Random rand) {
        List tones = this.raceIndex.get((Object)race);
        if (tones.isEmpty()) {
            throw new IllegalArgumentException("Unknown race:" + race);
        }
        int i = rand.nextInt(tones.size());
        return (HairTone)tones.get(i);
    }

    public static HairToneIndex create(Function<String, String> textFunc) {
        String text = textFunc.apply(SKIN_TONE_INDEX_CSV);
        HairToneIndex index = HairToneIndex.create(text);
        return index;
    }

    public static HairToneIndex create(String text) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<HairTone> configs = MapUtils.toObjects(records, HairTone.class);
        return new HairToneIndex(configs);
    }
}

