/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.time;

import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTimeSettingsSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(WorldTimeSettingsSystem.class);
    private List<Consumer<WorldTime>> settings = new ArrayList<Consumer<WorldTime>>();
    private Consumer[] settingsArray;
    private WorldTime worldTime;

    public void setWorldTime(WorldTime worldTime) {
        this.worldTime = worldTime;
    }

    public WorldTime getWorldTime() {
        return this.worldTime;
    }

    public void addSetting(Consumer<WorldTime> setting) {
        log.info("addSetting(" + setting + ")");
        this.settings.add(setting);
        this.settingsArray = null;
    }

    public void removeSetting(Consumer<WorldTime> setting) {
        log.info("removeSetting(" + setting + ")");
        this.settings.remove(setting);
        this.settingsArray = null;
    }

    protected Consumer[] getArray() {
        if (this.settingsArray == null) {
            this.settingsArray = this.settings.toArray(new Consumer[0]);
        }
        return this.settingsArray;
    }

    protected void initialize() {
        log.info("initialize()");
        if (this.worldTime == null) {
            this.worldTime = (WorldTime)this.getSystem(WorldTime.class, true);
        }
    }

    protected void terminate() {
    }

    public void update(SimTime time) {
        assert (this.worldTime != null) : "WorldTime was never set";
        for (Consumer setting : this.getArray()) {
            setting.accept(this.worldTime);
        }
    }
}

