/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.collision.CollisionResult;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.SafeArrayList;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.dnd.DragAndDropControl;
import com.simsilica.lemur.dnd.DragAndDropListener;
import com.simsilica.lemur.dnd.DragEvent;
import com.simsilica.lemur.dnd.DragSession;
import com.simsilica.lemur.dnd.DragStatus;
import com.simsilica.lemur.dnd.Draggable;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mythruna.client.ui.Grid;
import mythruna.client.ui.item.ContainerSection;
import mythruna.client.ui.item.Item;
import mythruna.client.ui.item.ItemBorder;
import mythruna.client.ui.item.ItemDraggable;
import mythruna.client.ui.item.ItemListener;
import mythruna.client.ui.item.ItemView;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSectionView
extends Node {
    static Logger log = LoggerFactory.getLogger(ContainerSectionView.class);
    private Node worldRoot;
    private ContainerSection section;
    private ColorRGBA gridColor = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.7f);
    private ColorRGBA activeColor = new ColorRGBA(0.40784314f, 0.38039216f, 0.3019608f, 0.5f);
    private ColorRGBA invisibleColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private ItemListener itemListener;
    private Grid grid;
    private InventorySize2d size;
    private DragAndDropHandler dndHandler = new DragAndDropHandler();
    private DragAndDropControl dndControl = new DragAndDropControl(new DragAndDropListener[]{this.dndHandler});
    private CursorObserver cursorObserver = new CursorObserver();
    private Map<EntityId, ItemEntry> itemIndex = new HashMap<EntityId, ItemEntry>();
    private SafeArrayList<ItemEntry> entryArray = new SafeArrayList(ItemEntry.class);
    private VersionedReference<List<Item>> listRef;
    private boolean enabled = true;

    public ContainerSectionView(Node worldRoot, ContainerSection section, ItemListener itemListener) {
        log.info("---------new ContainerSectionView(" + section + ")");
        this.worldRoot = worldRoot;
        this.section = section;
        this.itemListener = itemListener;
        this.listRef = section.createReference();
        this.updateChildViews();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.resetGridEnabled();
        for (ItemEntry entry : this.itemIndex.values()) {
            entry.setEnabled(this.isEnabled());
        }
    }

    protected void resetGridEnabled() {
        if (this.grid == null) {
            return;
        }
        if (this.enabled) {
            this.grid.addControl((Control)this.dndControl);
            this.grid.setGridColor(this.gridColor);
            this.grid.setActiveColor(this.activeColor);
        } else {
            this.grid.removeControl((Control)this.dndControl);
            this.grid.setGridColor(this.invisibleColor);
            this.grid.setActiveColor(this.invisibleColor);
        }
        this.grid.setEnabled(this.enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ContainerSection getSection() {
        return this.section;
    }

    public Vec3d getGridSize() {
        return this.grid == null ? new Vec3d(1.0, 1.0, 1.0) : this.grid.getSize();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.cursorObserver.update();
        if (this.listRef.update()) {
            this.updateChildViews();
        }
        for (ItemEntry entry : (ItemEntry[])this.entryArray.getArray()) {
            entry.update();
        }
    }

    protected void updateChildViews() {
        HashSet<ItemEntry> oldEntries = new HashSet<ItemEntry>(this.itemIndex.values());
        HashMap<EntityId, ItemEntry> newEntries = new HashMap<EntityId, ItemEntry>();
        for (Item item : (List)this.listRef.get()) {
            ItemEntry entry = this.itemIndex.get(item.getEntityId());
            if (entry == null) {
                log.info("new ItemEntry for:" + item);
                entry = new ItemEntry(item);
                entry.setEnabled(this.isEnabled());
                this.entryArray.add((Object)entry);
            } else {
                oldEntries.remove(entry);
            }
            log.info("view parent:" + entry.view.getParent() + "  grid:" + this.grid);
            if (entry.view.getParent() != this.grid) {
                log.info("attaching entry:" + entry);
                this.grid.attachChild((Spatial)entry.view);
            }
            newEntries.put(item.getEntityId(), entry);
        }
        for (ItemEntry old : oldEntries) {
            log.info("removing entry:" + old + "  view@:" + System.identityHashCode((Object)old.view));
            old.release();
            this.entryArray.remove((Object)old);
        }
        this.itemIndex = newEntries;
    }

    public void resetContainerSize(InventorySize2d size) {
        if (Objects.equals(this.size, size)) {
            return;
        }
        log.info(this.section.getEntityId() + " creating grid for size:" + size);
        this.size = size;
        if (this.grid != null) {
            this.grid.removeFromParent();
            this.grid.removeControl((Control)this.dndControl);
        }
        this.grid = new Grid(size.getXSlots(), size.getYSlots(), 1.0f, 0.4f);
        this.grid.setGridColor(this.gridColor);
        this.grid.setActiveColor(this.activeColor);
        this.grid.setName("sectionGrid:" + this.section.getEntityId().getId());
        this.grid.setUserData("oid", this.section.getEntityId().getId());
        this.resetGridEnabled();
        for (ItemEntry entry : this.itemIndex.values()) {
            this.grid.attachChild((Spatial)entry.view);
            entry.border.setParentGrid(this.grid);
        }
        CursorEventControl.addListenersToSpatial((Spatial)this.grid, (CursorListener[])new CursorListener[]{this.cursorObserver});
        this.attachChild((Spatial)this.grid);
    }

    protected Vec3i getCellLocation(Vector3f world) {
        Vector3f local = this.grid.worldToLocal(world, null);
        int xSlot = (int)local.x;
        int ySlot = (int)(-local.y);
        return new Vec3i(xSlot, ySlot, 0);
    }

    protected ItemEntry getItem(int xSlot, int ySlot) {
        for (ItemEntry entry : this.itemIndex.values()) {
            if (!entry.item.contains(xSlot, ySlot)) continue;
            return entry;
        }
        return null;
    }

    protected boolean contains(int xSlot, int ySlot, int width, int height) {
        if (this.size == null) {
            return false;
        }
        if (xSlot < 0 || ySlot < 0) {
            return false;
        }
        if (xSlot + width > this.size.getXSlots()) {
            return false;
        }
        return ySlot + height <= this.size.getYSlots();
    }

    protected ItemEntry getIntersection(ItemView skip, int xSlot, int ySlot, int width, int height) {
        for (ItemEntry entry : this.itemIndex.values()) {
            if (entry.view == skip || !entry.item.intersects(xSlot, ySlot, width, height)) continue;
            return entry;
        }
        return null;
    }

    private class DragAndDropHandler
    implements DragAndDropListener {
        private static final String SOURCE_SECTION = "sourceSection";
        private static final String CAN_COMBINE = "canCombine";

        public Draggable onDragDetected(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":onDragDetected(" + event + ")");
            Vec3i slot = ContainerSectionView.this.getCellLocation(event.getCollision().getContactPoint());
            log.info("hit cell:" + slot);
            ItemEntry hit = ContainerSectionView.this.getItem(slot.x, slot.y);
            log.info("   hit:" + hit);
            if (hit == null) {
                return null;
            }
            ContainerSectionView.this.grid.setActive(true);
            event.getSession().set("item", (Object)hit.view);
            event.getSession().set(SOURCE_SECTION, (Object)ContainerSectionView.this.section);
            event.getSession().set(CAN_COMBINE, new HashMap());
            Vector3f world = hit.view.getWorldTranslation();
            Vector3f loc = ContainerSectionView.this.worldRoot.worldToLocal(world, null);
            loc.z = (float)((double)loc.z + 0.25);
            hit.view.setLocalTranslation(loc);
            ContainerSectionView.this.worldRoot.attachChild((Spatial)hit.view);
            return new ItemDraggable(event.getViewPort(), hit.view, event.getLocation());
        }

        public void onDragEnter(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":+++++++ onDragEnter(" + event + ")");
            ContainerSectionView.this.grid.setActive(true);
            DragSession session = event.getSession();
            ItemDraggable draggable = (ItemDraggable)session.getDraggable();
            draggable.getBorder().setParentGrid(ContainerSectionView.this.grid);
        }

        public void onDragExit(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":------- onDragExit(" + event + ")");
            DragSession session = event.getSession();
            ItemDraggable draggable = (ItemDraggable)session.getDraggable();
            draggable.getBorder().setParentGrid(null);
            ContainerSectionView.this.grid.setActive(false);
        }

        public void onDragOver(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":onDragOver(" + event + ")");
            DragSession session = event.getSession();
            ItemView itemView = (ItemView)((Object)session.get("item", (Object)((ItemView)null)));
            Vec3i targetSlot = ContainerSectionView.this.getCellLocation(event.getCollision().getContactPoint());
            log.info("  targetSlot:" + targetSlot);
            Vector3f loc = ContainerSectionView.this.grid.worldToLocal(itemView.getWorldTranslation(), null);
            int xSlot = Math.round(loc.x);
            int ySlot = Math.round(-loc.y);
            ContainerSection source = (ContainerSection)((Object)session.get(SOURCE_SECTION, (Object)((ContainerSection)null)));
            InventorySize2d size = itemView.getItem().getItemSize();
            if (!ContainerSectionView.this.contains(xSlot, ySlot, size.getXSlots(), size.getYSlots())) {
                event.getSession().setDragStatus(DragStatus.NoTarget);
                return;
            }
            ItemDraggable draggable = (ItemDraggable)session.getDraggable();
            draggable.getBorder().setPosition(xSlot, ySlot);
            ItemEntry hit = ContainerSectionView.this.getIntersection(itemView, xSlot, ySlot, size.getXSlots(), size.getYSlots());
            log.info("overlap:" + hit);
            if (hit == null) {
                event.getSession().setDragStatus(DragStatus.ValidTarget);
            } else {
                Map canCombine = (Map)session.get(CAN_COMBINE, (Object)null);
                Boolean allowed = (Boolean)canCombine.get(hit.item.getEntityId());
                if (allowed == null) {
                    ContainerSectionView.this.itemListener.canCombine(itemView.getItem(), hit.item, can -> canCombine.put(hit.item.getEntityId(), can));
                }
                if (Boolean.TRUE.equals(allowed)) {
                    event.getSession().setDragStatus(DragStatus.ValidTarget);
                } else {
                    event.getSession().setDragStatus(DragStatus.InvalidTarget);
                }
            }
        }

        public void onDrop(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":onDrop(" + event + ")");
            DragSession session = event.getSession();
            ItemView itemView = (ItemView)((Object)session.get("item", (Object)((ItemView)null)));
            Vector3f loc = ContainerSectionView.this.grid.worldToLocal(itemView.getWorldTranslation(), null);
            int xSlot = Math.round(loc.x);
            int ySlot = Math.round(-loc.y);
            Vec3i slot = new Vec3i(xSlot, ySlot, 0);
            ContainerSection source = (ContainerSection)((Object)session.get(SOURCE_SECTION, (Object)((ContainerSection)null)));
            log.info("-----Dragged from:" + source.getEntityId() + " to:" + ContainerSectionView.this.section.getEntityId());
            itemView.forcePosition(slot);
            ContainerSectionView.this.grid.attachChild((Spatial)itemView);
            InventorySize2d size = itemView.getItem().getItemSize();
            ItemEntry hit = ContainerSectionView.this.getIntersection(itemView, xSlot, ySlot, size.getXSlots(), size.getYSlots());
            if (hit != null) {
                ContainerSectionView.this.itemListener.combine(itemView.getItem(), hit.item, ContainerSectionView.this.section);
            } else {
                ContainerSectionView.this.itemListener.itemDropped(itemView.getItem(), source, ContainerSectionView.this.section, slot);
            }
        }

        public void onDragDone(DragEvent event) {
            log.info(ContainerSectionView.this.section.getEntityId() + ":onDragDone(" + event + ")");
            ContainerSectionView.this.grid.setActive(false);
            DragSession session = event.getSession();
            log.info(" status:" + session.getDragStatus() + "  drop target:" + session.getDropTarget());
            ItemDraggable draggable = (ItemDraggable)session.getDraggable();
            if (session.getDropTarget() == null) {
                log.info("null drop target, reattaching locally");
                ItemView itemView = (ItemView)((Object)session.get("item", (Object)((ItemView)null)));
                ContainerSectionView.this.grid.attachChild((Spatial)itemView);
                itemView.reset();
            } else if (session.getDropTarget() == ContainerSectionView.this.grid) {
                log.info("we are the drop target, should already be attached");
            }
        }
    }

    private class CursorObserver
    extends DefaultCursorListener {
        private long nextIdle = 0L;
        private CollisionResult lastCollision;
        private Vec3d press = new Vec3d();
        private Vec3d lastClick = new Vec3d();
        private int clickCount = 0;
        private long lastClickTime;
        private double clickDistanceThresholdSq = 1.0;
        private long clickTimeThreshold = 250L;

        public void update() {
            if (this.clickCount == 0) {
                return;
            }
            long time = System.currentTimeMillis();
            if (time > this.nextIdle) {
                this.closeClick();
            }
        }

        protected void click(int buttonIndex, int count) {
            Vec3i slot = ContainerSectionView.this.getCellLocation(this.lastCollision.getContactPoint());
            ItemEntry hit = ContainerSectionView.this.getItem(slot.x, slot.y);
            if (hit == null) {
                log.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"click on:null"})));
                return;
            }
            log.info("click(" + count + ") on:" + hit.item.getEntityId());
            ContainerSectionView.this.itemListener.click(buttonIndex, count, ContainerSectionView.this.section, hit.item, slot);
        }

        protected void closeClick() {
            if (this.clickCount <= 0) {
                return;
            }
            this.click(0, this.clickCount);
            this.clickCount = 0;
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.isPressed()) {
                this.press.set((double)event.getLocation().x, (double)event.getLocation().y, 0.0);
                return;
            }
            Vec3d release = new Vec3d((double)event.getLocation().x, (double)event.getLocation().y, 0.0);
            if (release.distanceSq(this.press) > this.clickDistanceThresholdSq) {
                if (event.getButtonIndex() == 0) {
                    this.closeClick();
                }
                return;
            }
            if (event.getButtonIndex() > 0) {
                this.click(event.getButtonIndex(), 1);
                return;
            }
            long time = System.currentTimeMillis();
            if (time > this.lastClickTime + this.clickTimeThreshold) {
                this.closeClick();
                this.clickCount = 1;
            } else {
                ++this.clickCount;
            }
            this.lastClickTime = System.currentTimeMillis();
            this.nextIdle = time + this.clickTimeThreshold;
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.lastCollision = event.getCollision();
            super.cursorMoved(event, target, capture);
        }
    }

    private class ItemEntry {
        private Item item;
        private ItemView view;
        private ItemBorder border;
        private VersionedReference<InventorySize2d> itemSizeRef;
        private VersionedReference<Vec3i> slotRef;
        private boolean enabled = true;

        public ItemEntry(Item item) {
            this.item = item;
            this.view = new ItemView(item);
            this.itemSizeRef = item.createItemSizeRef();
            this.slotRef = item.createSlotRef();
            log.info("created ItemEntry()  @view:" + System.identityHashCode((Object)this.view));
            this.updateSize((InventorySize2d)this.itemSizeRef.get());
            this.updateSlot((Vec3i)this.slotRef.get());
        }

        protected void resetBorderState() {
            if (this.enabled) {
                this.border.setColor(null);
            } else {
                this.border.setColor(ContainerSectionView.this.invisibleColor);
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
            this.resetBorderState();
        }

        public void update() {
            if (this.itemSizeRef.update()) {
                this.updateSize((InventorySize2d)this.itemSizeRef.get());
            }
            if (this.slotRef.update()) {
                this.updateSlot((Vec3i)this.slotRef.get());
            }
        }

        public void release() {
            log.info("release()  @view:" + System.identityHashCode((Object)this.view));
            this.view.removeFromParent();
            if (this.border != null) {
                this.border.setParentGrid(null);
            }
        }

        protected void updateSize(InventorySize2d itemSize) {
            if (this.border == null) {
                this.border = new ItemBorder(itemSize.getXSlots(), itemSize.getYSlots());
                this.border.setParentGrid(ContainerSectionView.this.grid);
                this.resetBorderState();
            } else {
                this.border.setSize(itemSize.getXSlots(), itemSize.getYSlots());
            }
        }

        protected void updateSlot(Vec3i slot) {
            this.border.setPosition(slot.x, slot.y);
            if (this.view.getParent() != ContainerSectionView.this.grid && ContainerSectionView.this.grid != null) {
                ContainerSectionView.this.grid.attachChild((Spatial)this.view);
            }
        }
    }
}

