/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.config;

import com.google.common.base.MoreObjects;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Texture;
import java.io.Serializable;

public class TextureConfig
implements Serializable {
    static final long serialVersionUID = 42L;
    private String path;
    private boolean wrapS = true;
    private boolean wrapT = true;
    private boolean generateMips = true;
    private boolean flipY = true;
    private Integer anisotropy;
    private Texture.MinFilter minFilter;
    private Texture.MagFilter magFilter;

    public TextureConfig() {
        this("Textures/bad.jpg");
    }

    public TextureConfig(String path) {
        this(path, true, true, true);
    }

    public TextureConfig(String path, boolean wrapS, boolean wrapT, boolean generateMips) {
        this.path = path;
        this.wrapS = wrapS;
        this.wrapT = wrapT;
        this.generateMips = generateMips;
    }

    public void setWrapS(boolean b) {
        this.wrapS = b;
    }

    public boolean getWrapS() {
        return this.wrapS;
    }

    public void setWrapT(boolean b) {
        this.wrapT = b;
    }

    public boolean getWrapT() {
        return this.wrapT;
    }

    public void setGenerateMips(boolean b) {
        this.generateMips = b;
    }

    public boolean getGenerateMips() {
        return this.generateMips;
    }

    public void setFlipY(boolean b) {
        this.flipY = b;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setAnisotropy(Integer i) {
        this.anisotropy = i;
    }

    public Integer getAnisotropy() {
        return this.anisotropy;
    }

    public void setMinFilter(Texture.MinFilter minFilter) {
        this.minFilter = minFilter;
    }

    public Texture.MinFilter getMinFilter() {
        return this.minFilter;
    }

    public void setMagFilter(Texture.MagFilter magFilter) {
        this.magFilter = magFilter;
    }

    public Texture.MagFilter getMagFilter() {
        return this.magFilter;
    }

    public Texture create(AssetManager assets) {
        Texture t;
        TextureKey key = new TextureKey(this.path, this.flipY);
        key.setGenerateMips(this.generateMips);
        if (this.anisotropy != null) {
            key.setAnisotropy(this.anisotropy.intValue());
        }
        if ((t = assets.loadTexture(key)) == null) {
            throw new RuntimeException("Error loading texture:" + this.path);
        }
        if (this.wrapS) {
            t.setWrap(Texture.WrapAxis.S, Texture.WrapMode.Repeat);
        } else {
            t.setWrap(Texture.WrapAxis.S, Texture.WrapMode.EdgeClamp);
        }
        if (this.wrapT) {
            t.setWrap(Texture.WrapAxis.T, Texture.WrapMode.Repeat);
        } else {
            t.setWrap(Texture.WrapAxis.T, Texture.WrapMode.EdgeClamp);
        }
        if (this.minFilter != null) {
            t.setMinFilter(this.minFilter);
        }
        if (this.magFilter != null) {
            t.setMagFilter(this.magFilter);
        }
        return t;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("path", (Object)this.path).add("wrapS", this.wrapS).add("wrapT", this.wrapT).add("generateMips", this.generateMips).add("flipY", this.flipY).add("anisotropy", (Object)this.anisotropy).toString();
    }
}

