/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mblock.CellArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CellArrayProtocol {
    private int sizeBits;
    private int lengthBits;
    private int maxLength;

    public CellArrayProtocol() {
        this(8, 8);
    }

    public CellArrayProtocol(int sizeBits, int lengthBits) {
        this.sizeBits = sizeBits;
        this.lengthBits = lengthBits;
        this.maxLength = (1 << lengthBits) - 1;
    }

    public static byte[] toBytes(CellArray array) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new CellArrayProtocol().write(array, out);
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting cell array to bytes", e);
        }
    }

    public static CellArray fromBytes(byte[] array) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(array);
            return new CellArrayProtocol().read(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting bytes to cell array", e);
        }
    }

    public CellArray read(InputStream in) throws IOException {
        BitInputStream bIn = new BitInputStream(in);
        int xSize = bIn.readBits(this.sizeBits);
        int ySize = bIn.readBits(this.sizeBits);
        int zSize = bIn.readBits(this.sizeBits);
        CellArray data = new CellArray(xSize, ySize, zSize);
        this.readRleData(data.getArray(), 65535, 0, 16, bIn);
        this.readRleData(data.getArray(), -65536, 16, 16, bIn);
        int marker = 0;
        while ((marker = bIn.readBits(1)) != 0) {
        }
        return data;
    }

    public long write(CellArray data, OutputStream out) throws IOException {
        BitOutputStream bOut = new BitOutputStream(out);
        long bitCount = 0L;
        bOut.writeBits(data.getSizeX(), this.sizeBits);
        bOut.writeBits(data.getSizeY(), this.sizeBits);
        bOut.writeBits(data.getSizeZ(), this.sizeBits);
        bitCount += (long)(this.sizeBits * 3);
        int[] array = data.getArray();
        bitCount += this.writeRleData(array, 65535, 0, 16, bOut);
        bitCount += this.writeRleData(array, -65536, 16, 16, bOut);
        for (int bitsLeft = bOut.getPendingBits(); bitsLeft > 1; --bitsLeft) {
            bOut.writeBits(1, 1);
            ++bitCount;
        }
        bOut.writeBits(0, 1);
        return ++bitCount;
    }

    public long writeRleData(int[] array, int mask, int shift, int valueBits, BitOutputStream out) throws IOException {
        long bitCount = 0L;
        int lastVal = (array[0] & mask) >> shift;
        int count = 0;
        for (int val : array) {
            int part = (val & mask) >> shift;
            if (part == lastVal && count < this.maxLength) {
                ++count;
                continue;
            }
            if (count == 1) {
                out.writeBits(0, 1);
                ++bitCount;
            } else {
                out.writeBits(1, 1);
                ++bitCount;
                out.writeBits(count, this.lengthBits);
                bitCount += (long)this.lengthBits;
            }
            out.writeBits(lastVal, valueBits);
            bitCount += (long)valueBits;
            lastVal = part;
            count = 1;
        }
        if (count == 1) {
            out.writeBits(0, 1);
            ++bitCount;
        } else {
            out.writeBits(1, 1);
            ++bitCount;
            out.writeBits(count, this.lengthBits);
            bitCount += (long)this.lengthBits;
        }
        out.writeBits(lastVal, valueBits);
        return bitCount += (long)valueBits;
    }

    public void readRleData(int[] array, int mask, int shift, int valueBits, BitInputStream in) throws IOException {
        int index = 0;
        int total = array.length;
        while (index < total) {
            int marker = in.readBits(1);
            int length = marker == 0 ? 1 : in.readBits(this.lengthBits);
            int val = in.readBits(valueBits) << shift & mask;
            for (int i = 0; i < length; ++i) {
                int original = array[index];
                array[index] = original | val;
                ++index;
            }
        }
    }
}

