/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mphys.AbstractShape;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeCache<T extends AbstractShape>
implements ShapeFactory<T> {
    static Logger log = LoggerFactory.getLogger(ShapeCache.class);
    private final LoadingCache<ShapeKey, T> cache;
    private final ShapeFactory<T> delegate;

    public ShapeCache(ShapeFactory<T> delegate) {
        this(delegate, "maximumSize=1000");
    }

    public ShapeCache(ShapeFactory<T> delegate, String cacheSpec) {
        this.delegate = delegate;
        this.cache = CacheBuilder.from((String)cacheSpec).build(new CacheLoader<ShapeKey, T>(){

            public T load(ShapeKey key) {
                return ShapeCache.this.createShape(key);
            }
        });
    }

    public T createShape(String name, double scale, Mass mass) {
        return (T)((AbstractShape)this.cache.getUnchecked((Object)new ShapeKey(name, scale, mass)));
    }

    protected T createShape(ShapeKey key) {
        AbstractShape result = this.delegate.createShape(key.name, key.scale, key.mass);
        if (result == null) {
            log.error("No shape created for:" + key + ", delegate:" + this.delegate);
        }
        return (T)result;
    }

    protected static class ShapeKey {
        private String name;
        private double scale;
        private Mass mass;

        public ShapeKey(String name, double scale, Mass mass) {
            this.name = name;
            this.scale = scale;
            this.mass = mass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ShapeKey other = (ShapeKey)o;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.mass, other.mass)) {
                return false;
            }
            return !(Math.abs(this.scale - other.scale) > 1.0E-6);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scale, this.mass);
        }
    }
}

