/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.AbstractCellularSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellularNoise
extends AbstractCellularSampler {
    static Logger log = LoggerFactory.getLogger(CellularNoise.class);

    public CellularNoise() {
        this(0L);
    }

    public CellularNoise(long seed) {
        super(seed, 0.0, 1.0);
    }

    @Override
    public double getSample(double x, double y, double z) {
        double xf = x % 1.0;
        double zf = z % 1.0;
        double xCell = Math.floor(x);
        double zCell = Math.floor(z);
        double min = Double.POSITIVE_INFINITY;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                double zn;
                double zd;
                double xn = this.getRandomX(xCell + (double)i, zCell + (double)j) + (double)i;
                double xd = xf - xn;
                double d = xd * xd + (zd = zf - (zn = this.getRandomZ(xCell + (double)i, zCell + (double)j) + (double)j)) * zd;
                if (!(d < min)) continue;
                min = d;
            }
        }
        double result = Math.sqrt(min);
        return result;
    }
}

