/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.RigidBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringJoint<K, S extends AbstractShape>
implements Joint<K, S> {
    static Logger log = LoggerFactory.getLogger(SpringJoint.class);
    K id;
    RigidBody<K, S> altBody;
    Vec3d altOffset;
    RigidBody<K, S> mainBody;
    Vec3d mainOffset;
    Quatd relativeRotation;
    double damping;
    double springLength = 0.0;
    double test1;

    public SpringJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, RigidBody<K, S> altBody, Vec3d altOffset, Quatd relativeRotation, double damping, double test1) {
        this(id, mainBody, mainOffset, altBody, altOffset, relativeRotation, damping, 1.0, test1);
    }

    public SpringJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, RigidBody<K, S> altBody, Vec3d altOffset, Quatd relativeRotation, double damping, double springLength, double test1) {
        this.id = id;
        this.altBody = altBody;
        this.altOffset = altOffset;
        this.mainBody = mainBody;
        this.mainOffset = mainOffset;
        this.relativeRotation = relativeRotation;
        this.damping = damping;
        this.springLength = springLength;
        this.test1 = test1;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public RigidBody<K, S> getMainBody() {
        return this.mainBody;
    }

    @Override
    public RigidBody<K, S> getAltBody() {
        return this.altBody;
    }

    @Override
    public RigidBody<K, S> getOtherBody(RigidBody<K, S> body) {
        if (this.mainBody == body) {
            return this.altBody;
        }
        if (this.altBody == body) {
            return this.mainBody;
        }
        throw new IllegalArgumentException("Specified body:" + body.id + " is not part of this joint:" + this.id);
    }

    @Override
    public boolean isSleepy() {
        return this.mainBody.isSleepy() && (this.altBody == null || this.altBody.isSleepy());
    }

    @Override
    public void calculateInternals(double step) {
    }

    @Override
    public void calculatePositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2) {
    }

    @Override
    public void calculateVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
    }

    @Override
    public void resolve(double step) {
        double k = 1000.0;
        Vec3d world1 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d world2 = this.altOffset;
        if (this.altBody != null) {
            world2 = this.altBody.localToWorld(this.altOffset);
        }
        Vec3d delta = world2.subtract(world1);
        double distance = delta.length();
        double x = distance - this.springLength;
        double f = k * x;
        double rotDamping = this.test1 == 0.0 ? 1.0 : this.test1;
        Vec3d force = delta.mult(f / distance);
        this.mainBody.addForceAtBodyPoint(force, rotDamping, this.mainOffset);
    }
}

