/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    static Logger log = LoggerFactory.getLogger(MapUtils.class);
    private static LoadingCache<Class, TypeInfo> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, TypeInfo>(){

        public TypeInfo load(Class type) {
            return new TypeInfo(type);
        }
    });

    public static <T> T toObject(Map<String, String> map, Class<T> type) {
        TypeInfo info = (TypeInfo)cache.getUnchecked(type);
        T result = type.cast(info.create());
        for (Map.Entry<String, String> e : map.entrySet()) {
            info.set(result, e.getKey(), e.getValue());
        }
        return result;
    }

    public static <T> List<T> toObjects(Collection<Map<String, String>> maps, Class<T> type) {
        ArrayList<T> results = new ArrayList<T>();
        for (Map<String, String> map : maps) {
            results.add(MapUtils.toObject(map, type));
        }
        return results;
    }

    protected static Setter findSetter(Class type, String name) {
        try {
            String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method m = type.getDeclaredMethod(methodName, String.class);
            return new MethodSetter(m);
        }
        catch (NoSuchMethodException e) {
            if (log.isDebugEnabled()) {
                log.debug("No setter method found for:" + name + " trying field.");
            }
            try {
                Field f = type.getDeclaredField(name);
                return new FieldSetter(f);
            }
            catch (NoSuchFieldException e2) {
                throw new IllegalArgumentException("No setter or field for:" + name, e2);
            }
        }
    }

    private static class TypeInfo {
        private Class type;
        private Constructor ctor;
        private ReentrantReadWriteLock updateLock = new ReentrantReadWriteLock();
        private Map<String, Setter> setterIndex = new HashMap<String, Setter>();

        public TypeInfo(Class type) {
            this.type = type;
            try {
                this.ctor = type.getDeclaredConstructor(new Class[0]);
                this.ctor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Type has no no-arg constructor:" + type, e);
            }
        }

        public Object create() {
            try {
                return this.ctor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Error instantiating:" + this.type + " using:" + this.ctor, e);
            }
        }

        public void set(Object target, String field, String value) {
            Setter setter = this.setterForName(field);
            setter.set(target, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Setter setterForName(String name) {
            Setter result;
            this.updateLock.readLock().lock();
            try {
                result = this.setterIndex.get(name);
                if (result != null) {
                    Setter setter = result;
                    return setter;
                }
            }
            finally {
                this.updateLock.readLock().unlock();
            }
            this.updateLock.writeLock().lock();
            try {
                result = this.setterIndex.get(name);
                if (result != null) {
                    Setter setter = result;
                    return setter;
                }
                result = MapUtils.findSetter(this.type, name);
                this.setterIndex.put(name, result);
                Setter setter = result;
                return setter;
            }
            finally {
                this.updateLock.writeLock().unlock();
            }
        }
    }

    private static class MethodSetter
    implements Setter {
        private Method method;

        public MethodSetter(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public void set(Object target, String value) {
            try {
                this.method.invoke(target, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error calling:" + this.method, e);
            }
        }
    }

    private static class FieldSetter
    implements Setter {
        private Field field;

        public FieldSetter(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        @Override
        public void set(Object target, String value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error setting:" + this.field, e);
            }
        }
    }

    private static interface Setter {
        public void set(Object var1, String var2);
    }
}

