/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.io.Resources;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.progress.view.TrackerView;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ProgressState.class);
    private Container progressWindow;
    private Label splashLabel;
    private TrackerView trackerView;
    private VersionedHolder<String> splash;
    private VersionedReference<String> splashRef;
    private List<String> splashImages = new ArrayList<String>();
    private int nextSplashIndex = 0;
    private float imageDuration = 8.0f;
    private float imageTime = 0.0f;
    private GuiComponent lastIcon;
    private float fade = 0.0f;
    private ColorRGBA background = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private long lastEnableTime;
    private Thread renderThread;
    private Set<Object> requesters = new HashSet<Object>();

    public ProgressState() {
        this.setEnabled(false);
    }

    public void setSplashImages(List<String> list) {
        this.runOnRender(() -> {
            this.splashImages.clear();
            this.splashImages.addAll(list);
            this.imageTime = 0.0f;
        });
    }

    public void openView(Object requester) {
        this.openView(requester, null);
    }

    public void openView(Object requester, String text) {
        this.runOnRender(() -> {
            log.info("openView(" + requester + ", " + text + ")");
            this.requesters.add(requester);
            this.setText(text);
            this.setEnabled(true);
        });
    }

    public void releaseView(Object requester) {
        this.runOnRender(() -> {
            log.info("releaseView(" + requester + ")");
            this.requesters.remove(requester);
            this.setEnabled(!this.requesters.isEmpty());
        });
    }

    public void setText(String text) {
        this.runOnRender(() -> this.trackerView.setDefaultText(text));
    }

    public void setSplash(String splash) {
        this.runOnRender(() -> {
            log.info("setSplash(" + splash + ")  lastIcon:" + this.lastIcon);
            this.splash.updateObject((Object)splash);
            this.imageTime = this.imageDuration;
            this.splashLabel.setIcon(null);
            int index = this.splashImages.indexOf(splash);
            if (index >= 0) {
                this.nextSplashIndex = index + 1;
                if (this.nextSplashIndex >= this.splashImages.size()) {
                    this.nextSplashIndex = 0;
                }
            }
            this.clearLastIcon();
        });
    }

    public boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void runOnRender(Runnable r) {
        if (this.isRenderThread()) {
            r.run();
        } else {
            this.getApplication().enqueue(r);
        }
    }

    public void setMainThreadFilter(Predicate<Thread> filter) {
        this.trackerView.setMainThreadFilter(filter);
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.splash = new VersionedHolder(null);
        this.splashRef = this.splash.createReference();
        this.progressWindow = new Container((GuiLayout)new BorderLayout(), new ElementId("popup"));
        this.progressWindow.setLocalScale(1.5f);
        this.splashLabel = new Label("");
        this.splashLabel.setFontSize(1.0f);
        this.splashLabel.setText(null);
        this.splashLabel.setInsets(new Insets3f(5.0f, 5.0f, -5.0f, 5.0f));
        this.trackerView = (TrackerView)this.progressWindow.addChild((Node)new TrackerView(), new Object[]{BorderLayout.Position.South});
        this.trackerView.setExpandOnly(false);
        this.loadDefaultSplashImages();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.progressWindow, this.background);
        long enableTime = System.currentTimeMillis();
        if (enableTime > this.lastEnableTime + 1000L) {
            this.lastEnableTime = enableTime;
            this.imageTime = 0.0f;
            this.clearLastIcon();
        }
    }

    protected void onDisable() {
        log.info("onDisable()");
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this.progressWindow);
    }

    public void update(float tpf) {
        this.imageTime -= tpf;
        log.info("imageTime:" + this.imageTime + "  fade:" + this.fade);
        if (this.imageTime < 0.0f) {
            this.imageTime = this.imageDuration;
            this.pickImage();
        }
        if (this.lastIcon instanceof ColoredComponent) {
            this.fade -= tpf;
            if (this.fade < 0.0f) {
                this.clearLastIcon();
            } else {
                ((ColoredComponent)this.lastIcon).setAlpha(this.fade);
            }
        }
        if (this.splashRef.update()) {
            String s = (String)this.splash.getObject();
            if (s == null) {
                this.splashLabel.setIcon(null);
                this.progressWindow.removeChild((Node)this.splashLabel);
            } else {
                this.lastIcon = this.splashLabel.getIcon();
                IconComponent icon = new IconComponent(s);
                icon.setVAlignment(VAlignment.Center);
                icon.setHAlignment(HAlignment.Center);
                this.splashLabel.setIcon((GuiComponent)icon);
                this.progressWindow.addChild((Node)this.splashLabel, new Object[0]);
                if (this.lastIcon instanceof ColoredComponent) {
                    ((GuiControl)this.splashLabel.getControl(GuiControl.class)).addComponent(this.lastIcon);
                    this.fade = 1.0f;
                }
            }
        }
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
    }

    protected void loadDefaultSplashImages() {
        URL u = ((Object)((Object)this)).getClass().getResource("/Splash/splash.index");
        if (u == null) {
            log.warn("No splash index found.");
            return;
        }
        try {
            List names = Resources.readLines((URL)u, (Charset)StandardCharsets.UTF_8);
            ArrayList<String> resources = new ArrayList<String>();
            for (String s : names) {
                resources.add("Splash/" + s);
            }
            Collections.shuffle(resources);
            this.setSplashImages(resources);
        }
        catch (IOException e) {
            log.error("Error loading:" + u, (Throwable)e);
        }
    }

    protected void pickImage() {
        if (this.splashImages.isEmpty()) {
            return;
        }
        int i = this.nextSplashIndex++;
        if (this.nextSplashIndex > this.splashImages.size()) {
            this.nextSplashIndex = 0;
        }
        this.splash.updateObject((Object)this.splashImages.get(i));
        log.info("pickImage picked:" + this.splashImages.get(i));
    }

    protected void clearLastIcon() {
        if (this.lastIcon == null) {
            return;
        }
        log.info("clearing last icon");
        ((GuiControl)this.splashLabel.getControl(GuiControl.class)).removeComponent(this.lastIcon);
        this.lastIcon = null;
    }
}

