/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.renderer.Camera;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.WatchedEntity;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.input.AbstractMovementTarget;
import com.simsilica.input.MovementState;
import com.simsilica.input.MovementTarget;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.PositionTransition3d;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.World;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CameraState;
import com.simsilica.state.GameSystemsState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.GameSettingsState;
import mythruna.client.MainGameFunctions;
import mythruna.client.PostProcessingState;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.TimeState;
import mythruna.client.view.EnvironmentState;
import mythruna.client.view.input.ShellState;
import mythruna.es.MovementInput;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.shell.AbstractShellCommand;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellCommand;
import mythruna.sim.PathBuffer;
import mythruna.world.local.LocalSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(AvatarState.class);
    public static final FunctionId F_SUPER_RUN = new FunctionId("Movement", "Super Run");
    public static final FunctionId F_JUMP = new FunctionId("Movement", "Jump");
    public static final FunctionId F_WALK = new FunctionId("Movement", "Walk/Jog");
    public static final double DISTANCE_EPSILON = 1.0E-4;
    public static final double ROTATION_EPSILON = 1.0E-4;
    public static final double DISTANCE_EPSILON_SQ = 1.0E-8;
    private EntityData ed;
    private EntityId avatarId;
    private VersionedHolder<EntityId> avatarIdHolder = new VersionedHolder();
    private GameSession session;
    private SessionObserver sessionObserver = new SessionObserver(this);
    private EnvironmentState environment;
    private World world;
    private MBlockCollisionSystem collisionSystem;
    private VersionedHolder<Vec3d> viewPosition = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<Quatd> viewOrientation = new VersionedHolder((Object)new Quatd());
    private Camera camera;
    private WalkHandler movementHandler = new WalkHandler();
    private VersionedHolder<Vec3d> eyePosition = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<Vec3d> cameraPosition = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<Quatd> cameraOrientation = new VersionedHolder((Object)new Quatd());
    private boolean dragLocked = false;
    private double savedYaw;
    private double savedPitch;
    private double draggedYaw;
    private double draggedPitch;
    private Quatd lockOrientation = new Quatd();
    private float originalFov = 60.0f;
    private float targetFov = 60.0f;
    private float fovDelta = 0.0f;
    private float fovSpeed = 5.0f;
    private WatchedEntity self;
    private TimeState time;
    private JobState workers;
    private LocalSpace localSpace;
    private LocalSpaceUpdater localSpaceUpdater;
    private VersionedReference<Integer> lightRef;
    private VersionedReference<Double> underwaterRef;
    private PathBuffer pathBuffer;
    private TapeTask tape;
    private boolean playback = false;
    private int thirdPersonDistance = 0;
    private VersionedReference<Boolean> invertYRef;
    private int phase = 2;
    private double underwaterLevel = 0.0;
    private int nullCount = 0;

    public EntityId getAvatarId() {
        return this.avatarId;
    }

    public VersionedReference<EntityId> createAvatarIdReference() {
        return this.avatarIdHolder.createReference();
    }

    public void setPrimaryDrag(boolean primaryDrag) {
        this.movementHandler.setPrimaryDrag(primaryDrag);
        this.setDragLocked(primaryDrag);
    }

    protected void setDragLocked(boolean dragLocked) {
        if (this.dragLocked == dragLocked) {
            return;
        }
        this.dragLocked = dragLocked;
        MovementState moveState = (MovementState)this.getState(MovementState.class, true);
        if (dragLocked) {
            this.savedYaw = moveState.getYaw();
            this.savedPitch = moveState.getPitch();
            moveState.setPitch(0.0);
            this.originalFov = ((CameraState)this.getState(CameraState.class)).getFieldOfView();
            this.lockOrientation.set(this.movementHandler.rotation);
        } else if (this.thirdPersonDistance > 0) {
            moveState.setYaw(this.savedYaw);
            moveState.setPitch(this.savedPitch);
        } else {
            moveState.setYaw(this.draggedYaw);
            moveState.setPitch(this.draggedPitch);
        }
        this.resetFov();
    }

    protected void resetFov() {
        if (!this.dragLocked || this.thirdPersonDistance > 0) {
            if (this.phase > 0) {
                this.targetFov = this.originalFov;
                this.fovDelta = this.targetFov - ((CameraState)this.getState(CameraState.class)).getFieldOfView();
            } else {
                this.targetFov = this.originalFov;
                this.fovDelta = 0.0f;
            }
            return;
        }
        if (this.thirdPersonDistance == 0) {
            if (this.phase > 0) {
                this.targetFov = this.originalFov + 15.0f;
                this.fovDelta = this.targetFov - ((CameraState)this.getState(CameraState.class)).getFieldOfView();
            } else {
                this.targetFov = this.originalFov;
                this.fovDelta = 0.0f;
            }
        }
    }

    public boolean isDragLocked() {
        return this.dragLocked;
    }

    public void toggleThirdPerson() {
        ++this.thirdPersonDistance;
        if (this.thirdPersonDistance > 3) {
            this.thirdPersonDistance = 0;
        }
        if (this.dragLocked) {
            this.resetFov();
        }
    }

    public void setThirdPersonDistance(int thirdPersonDistance) {
        this.thirdPersonDistance = thirdPersonDistance;
    }

    public int getThirdPersonDistance() {
        return this.thirdPersonDistance;
    }

    public Vec3d getPosition() {
        return (Vec3d)this.viewPosition.getObject();
    }

    public Vec3d getEyePosition() {
        return (Vec3d)this.eyePosition.getObject();
    }

    public Vec3d getCameraPosition() {
        return (Vec3d)this.cameraPosition.getObject();
    }

    public Quatd getViewFacing() {
        return (Quatd)this.viewOrientation.getObject();
    }

    public Quatd getCameraFacing() {
        return (Quatd)this.cameraOrientation.getObject();
    }

    public VersionedReference<Vec3d> createPositionReference() {
        return this.viewPosition.createReference();
    }

    public VersionedReference<Quatd> createOrientationReference() {
        return this.viewOrientation.createReference();
    }

    public VersionedReference<Vec3d> createEyePositionReference() {
        return this.eyePosition.createReference();
    }

    public VersionedReference<Vec3d> createCameraPositionReference() {
        return this.cameraPosition.createReference();
    }

    public VersionedReference<Quatd> createCameraOrientationReference() {
        return this.cameraOrientation.createReference();
    }

    public Rayd getViewRay() {
        Vec3d dir = this.movementHandler.rotation.mult(Vec3d.UNIT_Z);
        dir.normalizeLocal();
        Rayd ray = new Rayd((Vec3d)this.eyePosition.getObject(), dir);
        return ray;
    }

    public Rayd getViewRay(Vec3d dir) {
        Rayd ray = new Rayd((Vec3d)this.eyePosition.getObject(), dir);
        return ray;
    }

    public Rayd getViewRay(Vec3d offset, Vec3d dir) {
        Vec3d loc = ((Vec3d)this.eyePosition.getObject()).add(offset);
        Rayd ray = new Rayd(loc, dir);
        return ray;
    }

    public Iterator<BlockIterator.Intersection> pick(Rayd ray, int distance) {
        if (this.world == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.collisionSystem.rayIterator(ray, (double)distance);
    }

    public Iterator<BlockIterator.Intersection> pick(int distance) {
        if (this.world == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.pick(this.getViewRay(), distance);
    }

    public LocalSpace getLocalSpace() {
        return this.localSpace;
    }

    public void record() {
        log.info("record()");
        this.pathBuffer = new PathBuffer();
        this.tape = new RecordTask(this.pathBuffer);
    }

    public void play() {
        log.info("play()");
        if (this.pathBuffer == null) {
            return;
        }
        this.tape = new PlayTask(this.pathBuffer);
    }

    public void stop() {
        log.info("stop()");
        this.tape = null;
        this.playback = false;
    }

    protected void initialize(Application app) {
        this.environment = (EnvironmentState)this.getState(EnvironmentState.class, true);
        this.invertYRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createInvertYRef();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.map(F_SUPER_RUN, 29, new Object[0]);
        inputMapper.map(F_SUPER_RUN, 157, new Object[0]);
        inputMapper.map(F_JUMP, 57, new Object[0]);
        inputMapper.map(F_JUMP, Button.JOYSTICK_BUTTON2, new Object[0]);
        inputMapper.map(F_WALK, 45, new Object[0]);
        BlackboardState blackboard = (BlackboardState)this.getState("session", BlackboardState.class, true);
        blackboard.set("position", this.viewPosition);
        blackboard.set("orientation", this.viewOrientation);
        this.camera = ((CameraState)this.getState(CameraState.class, true)).getCamera();
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.time = (TimeState)this.getState(TimeState.class, true);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        this.avatarIdHolder.setObject((Object)this.avatarId);
        this.world = sessionState.getWorld();
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        this.collisionSystem = new MBlockCollisionSystem(this.world, colliders);
        log.info("Avatar:" + this.avatarId);
        SpawnPosition pos = (SpawnPosition)((GameSystemsState)this.getState(GameSystemsState.class, true)).get(SpawnPosition.class);
        if (pos == null) {
            log.warn("Player spawn position is missing from game systems");
            pos = (SpawnPosition)this.ed.getComponent(this.avatarId, SpawnPosition.class);
        }
        log.info("spawn:" + pos);
        this.viewPosition.setObject((Object)pos.getLocation().add(0.0, 0.8, 0.0));
        this.viewOrientation.setObject((Object)pos.getOrientation());
        this.eyePosition.setObject((Object)pos.getLocation().add(this.calculateEyeOffset()));
        this.cameraPosition.setObject((Object)pos.getLocation().add(this.calculateCameraOffset()));
        this.workers = (JobState)this.getState(JobState.class);
        this.localSpace = new LocalSpace(this.world);
        this.lightRef = this.localSpace.getLightValue().createReference();
        this.underwaterRef = this.localSpace.getUnderwaterValue().createReference();
        this.updateCamera((Vec3d)this.cameraPosition.getObject(), pos.getOrientation().mult(Vec3d.UNIT_Z));
        this.self = this.ed.watchEntity(this.avatarId, new Class[]{BodyPosition.class});
        log.info("self:" + this.self);
        BodyPosition bPos = (BodyPosition)this.self.get(BodyPosition.class);
        log.info("self pos:" + bPos);
        if (bPos != null) {
            bPos.initialize(this.avatarId, 12);
        }
        if (this.getState(HostedGameState.class) != null && ((HostedGameState)this.getState(HostedGameState.class)).isSinglePlayer()) {
            CommandShell clientShell = ((ShellState)this.getState(ShellState.class, true)).getClientShell();
            clientShell.addCommand("record", (ShellCommand)new RecordCommand());
            clientShell.addCommand("stop", (ShellCommand)new StopCommand());
            clientShell.addCommand("play", (ShellCommand)new PlayCommand());
        }
    }

    protected void cleanup(Application app) {
        this.localSpace.release();
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, false);
        if (sessionState != null) {
            sessionState.removeGameSessionListener((GameSessionListener)this.sessionObserver);
        }
    }

    protected void onEnable() {
        ((MovementState)this.getState(MovementState.class, true)).setMovementTarget((MovementTarget)this.movementHandler);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(F_SUPER_RUN, (Object)this.movementHandler, "setSuperRun", true);
        inputMapper.addDelegate(F_JUMP, (Object)this.movementHandler, "setJump", true);
        inputMapper.addDelegate(F_WALK, (Object)this.movementHandler, "toggleWalk");
        inputMapper.addDelegate(MainGameFunctions.F_THIRD_PERSON, (Object)this, "toggleThirdPerson");
        ((MovementState)this.getState(MovementState.class, true)).setInvertPitch(((Boolean)this.invertYRef.get()).booleanValue());
    }

    protected void onDisable() {
        ((MovementState)this.getState(MovementState.class, true)).setMovementTarget(null);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(F_SUPER_RUN, (Object)this.movementHandler, "setSuperRun");
        inputMapper.removeDelegate(F_JUMP, (Object)this.movementHandler, "setJump");
        inputMapper.removeDelegate(F_WALK, (Object)this.movementHandler, "toggleWalk");
        inputMapper.removeDelegate(MainGameFunctions.F_THIRD_PERSON, (Object)this, "toggleThirdPerson");
    }

    public void update(float tpf) {
        if (this.fovDelta != 0.0f) {
            float fov = ((CameraState)this.getState(CameraState.class)).getFieldOfView();
            fov += this.fovDelta * tpf * this.fovSpeed;
            if (this.fovDelta > 0.0f) {
                if (fov > this.targetFov) {
                    fov = this.targetFov;
                    this.fovDelta = 0.0f;
                }
            } else if (fov < this.targetFov) {
                fov = this.targetFov;
                this.fovDelta = 0.0f;
            }
            ((CameraState)this.getState(CameraState.class)).setFieldOfView(fov);
        }
        if (this.invertYRef.update()) {
            ((MovementState)this.getState(MovementState.class, true)).setInvertPitch(((Boolean)this.invertYRef.get()).booleanValue());
        }
        if (this.tape != null && !this.tape.update(this.time.getTime())) {
            this.tape = null;
        }
        if (!this.playback) {
            this.movementHandler.send();
            if (!this.dragLocked) {
                this.camera.setRotation(this.movementHandler.rotation.toQuaternion());
            } else if (this.thirdPersonDistance == 0) {
                if (this.phase > 1) {
                    MovementState moveState = (MovementState)this.getState(MovementState.class, true);
                    double yaw = moveState.getYaw();
                    double pitch = moveState.getPitch();
                    double yawDelta = yaw - this.savedYaw;
                    if (yawDelta > Math.PI) {
                        yawDelta = yaw - (this.savedYaw + Math.PI * 2);
                    } else if (yawDelta < -Math.PI) {
                        yawDelta = yaw + Math.PI * 2 - this.savedYaw;
                    }
                    double pitchDelta = pitch - this.savedPitch;
                    this.draggedYaw = this.savedYaw + yawDelta * 0.5;
                    this.draggedPitch = this.savedPitch + pitchDelta * 0.25;
                    Quatd temp = new Quatd().fromAngles(this.draggedPitch, this.draggedYaw, 0.0);
                    this.camera.setRotation(temp.toQuaternion());
                } else {
                    this.draggedYaw = this.savedYaw;
                    this.draggedPitch = this.savedPitch;
                }
            }
        }
        if (this.self.applyChanges()) {
            log.info("self changes");
            bPos = (BodyPosition)this.self.get(BodyPosition.class);
            log.info("self pos update:" + bPos);
            if (bPos != null) {
                bPos.initialize(this.avatarId, 12);
            }
        } else {
            bPos = (BodyPosition)this.self.get(BodyPosition.class);
            this.updateAvatarPosition(bPos);
        }
        this.localSpace.applyWorldUpdates();
        if (this.lightRef.update()) {
            int sun = this.localSpace.getLightValue().getSun();
            double override = 0.0;
            if (sun <= 3) {
                override = 1.0;
            } else if (sun < 9) {
                override = 1.0 - (double)(sun - 3) / 6.0;
            }
            this.environment.setLocalOverrideTarget(override);
        }
        if (this.underwaterRef.update() && this.underwaterLevel != (Double)this.underwaterRef.get()) {
            this.underwaterLevel = (Double)this.underwaterRef.get();
            ((PostProcessingState)this.getState(PostProcessingState.class)).setWaterLevel(this.underwaterLevel);
        }
    }

    protected void updateAvatarPosition(BodyPosition bPos) {
        ChildPositionTransition3d frame;
        long t = this.time.getTime();
        if (bPos == null) {
            ++this.nullCount;
            if (this.nullCount == 1) {
                log.warn("Body position is null");
            }
            return;
        }
        if (this.nullCount > 0) {
            log.info("Body position resumed after:" + this.nullCount + " missed frames");
            this.nullCount = 0;
        }
        if ((frame = bPos.getFrame(t)) == null) {
            if (t != 0L) {
                log.warn("no transition frame for time:" + t);
            }
            return;
        }
        Vec3d v = frame.getPosition(t, true);
        boolean cameraMoved = false;
        if (v.distanceSq((Vec3d)this.viewPosition.getObject()) > 1.0E-8) {
            this.viewPosition.setObject((Object)v.clone());
            this.eyePosition.setObject((Object)v.add(this.calculateEyeOffset()));
            cameraMoved = true;
        }
        Quatd q = frame.getRotation(t, true);
        cameraMoved = true;
        this.viewOrientation.setObject((Object)q.clone());
        if (cameraMoved) {
            this.cameraPosition.setObject((Object)v.add(this.calculateCameraOffset()));
            this.updateCamera((Vec3d)this.cameraPosition.getObject(), this.movementHandler.rotation.mult(Vec3d.UNIT_Z));
        }
        GridCell cell = GameConstants.LEAF_GRID.getContainingCell(v);
        v.x -= (double)cell.getWorldOrigin().x;
        v.z -= (double)cell.getWorldOrigin().z;
        v.addLocal(this.calculateCameraOffset());
        this.camera.setLocation(v.toVector3f());
    }

    protected void updateCamera(Vec3d cam, Vec3d look) {
        if (this.localSpace.updatePosition((Vec3d)this.cameraPosition.getObject(), look) && (this.localSpaceUpdater == null || !this.localSpaceUpdater.queued)) {
            log.info("queuing LocalSpaceUpdater");
            this.localSpaceUpdater = new LocalSpaceUpdater();
            this.workers.execute((Job)this.localSpaceUpdater, -1);
        }
    }

    protected Vec3d calculateEyeOffset() {
        return new Vec3d(0.0, 1.5, 0.0);
    }

    protected Vec3d calculateCameraOffset() {
        Vec3d eye = new Vec3d(0.0, 1.5, 0.0);
        if (this.thirdPersonDistance > 0) {
            int zoomOut = this.thirdPersonDistance - 1;
            Vec3d back = new Vec3d(this.camera.getDirection().mult((float)(-3 - zoomOut)));
            eye.addLocal(back);
        } else {
            Vec3d fwd = new Vec3d(this.camera.getDirection().mult(0.1f));
            eye.addLocal(fwd);
        }
        return eye;
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver(AvatarState avatarState) {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }
    }

    public class WalkHandler
    extends AbstractMovementTarget {
        private Quatd rotation = new Quatd();
        private Vec3d forces = new Vec3d();
        private MovementInput lastSent = null;
        private boolean superRun = false;
        private boolean jump = false;
        private boolean walk = false;
        private int flags = 0;
        private boolean primaryDrag = false;
        private boolean secondaryDrag = false;

        public void toggleWalk() {
            this.walk = !this.walk;
            log.info("walk:" + this.walk);
        }

        public void setSuperRun(InputState state) {
            this.superRun = state == InputState.Positive;
        }

        public void setJump(InputState state) {
            this.jump = state == InputState.Positive;
            this.resetFlags();
        }

        public void setPrimaryDrag(boolean primaryDrag) {
            this.primaryDrag = primaryDrag;
            this.resetFlags();
        }

        public void setSecondaryDrag(boolean primaryDrag) {
            this.secondaryDrag = this.secondaryDrag;
            this.resetFlags();
        }

        protected void resetFlags() {
            this.flags = 0;
            if (this.jump) {
                this.flags |= 1;
            }
            if (this.primaryDrag) {
                this.flags |= 2;
            }
            if (this.secondaryDrag) {
                this.flags |= 4;
            }
        }

        public void move(Quatd rotation, Vec3d movementForces, double tpf) {
            this.rotation.set(rotation);
            if (this.superRun) {
                this.forces.set(movementForces.mult(4.0));
            } else if (this.walk) {
                this.forces.set(movementForces.mult(0.5));
            } else {
                this.forces.set(movementForces);
            }
        }

        public void setRotation(Quatd rotation) {
            this.rotation.set(rotation);
            AvatarState.this.cameraOrientation.setObject((Object)this.rotation);
        }

        public Quatd getRotation() {
            return this.rotation;
        }

        public void send() {
            MovementInput move;
            this.lastSent = move = new MovementInput(this.forces.clone(), this.rotation.clone(), (byte)this.flags);
            AvatarState.this.session.setMovementInput(move);
        }
    }

    private class RecordTask
    implements TapeTask {
        PathBuffer buffer;

        public RecordTask(PathBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public long getDuration() {
            return this.buffer.getDuration();
        }

        @Override
        public boolean update(long time) {
            Vec3d pos = new Vec3d(AvatarState.this.camera.getLocation());
            Quatd quat = new Quatd(AvatarState.this.camera.getRotation());
            this.buffer.addFrame(time, pos, quat);
            return true;
        }
    }

    private static interface TapeTask {
        public boolean update(long var1);

        public long getDuration();
    }

    private class PlayTask
    implements TapeTask {
        PathBuffer buffer;
        private List<PositionTransition3d> frames = new ArrayList<PositionTransition3d>();
        private PositionTransition3d currentFrame;
        private Long startTime = null;
        private long currentTime;
        private int currentIndex;

        public PlayTask(PathBuffer buffer) {
            this.buffer = buffer;
            this.frames = buffer.getFrames();
            this.currentTime = 0L;
            this.currentIndex = 0;
            this.currentFrame = this.frames.get(this.currentIndex);
            AvatarState.this.playback = true;
        }

        @Override
        public long getDuration() {
            return this.startTime == null ? -1L : this.currentTime - this.startTime;
        }

        @Override
        public boolean update(long time) {
            if (!this.advance(time)) {
                AvatarState.this.playback = false;
                return false;
            }
            AvatarState.this.camera.setLocation(this.currentFrame.getPosition(this.currentTime, true).toVector3f());
            AvatarState.this.camera.setRotation(this.currentFrame.getRotation(this.currentTime, true).toQuaternion());
            return true;
        }

        protected boolean advance(long time) {
            if (this.startTime == null) {
                this.startTime = time;
                time = 0L;
            } else {
                time -= this.startTime.longValue();
            }
            if (this.currentFrame.containsTime(time)) {
                this.currentTime = time;
                return true;
            }
            while (this.currentIndex < this.frames.size()) {
                this.currentFrame = this.frames.get(this.currentIndex);
                if (this.currentFrame.containsTime(time)) {
                    this.currentTime = time;
                    return true;
                }
                ++this.currentIndex;
            }
            return false;
        }
    }

    private class RecordCommand
    extends AbstractShellCommand {
        public RecordCommand() {
            super(new String[]{"Records the movement of the player."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("record", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.record();
            return null;
        }
    }

    private class StopCommand
    extends AbstractShellCommand {
        public StopCommand() {
            super(new String[]{"Stops and playback or recording."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("stop", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.stop();
            return null;
        }
    }

    private class PlayCommand
    extends AbstractShellCommand {
        public PlayCommand() {
            super(new String[]{"Plays back previously recorded player movement."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("play", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.play();
            return null;
        }
    }

    private class LocalSpaceUpdater
    implements Job {
        private volatile boolean queued;

        public void runOnWorker() {
            this.queued = false;
            AvatarState.this.localSpace.reload();
        }

        public double runOnUpdate() {
            AvatarState.this.localSpaceUpdater = null;
            return 0.0;
        }
    }

    private class Angle {
        public double radians;

        public Angle(AvatarState avatarState, double radians) {
            this.radians = radians;
        }

        public String toString() {
            return "Angle[" + Math.toDegrees(this.radians) + "]";
        }
    }
}

