/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos.net;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.ethereal.NetworkStateListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyVisibility
implements ComponentVisibility {
    static Logger log = LoggerFactory.getLogger(BodyVisibility.class);
    private NetworkStateListener netState;
    private EntityData ed;
    private Set<Long> lastActiveIds;
    private Map<EntityId, BodyPosition> lastValues = new HashMap<EntityId, BodyPosition>();

    protected BodyVisibility(NetworkStateListener netState, Set<Long> lastActiveIds) {
        this.netState = netState;
        this.lastActiveIds = lastActiveIds;
    }

    public BodyVisibility(NetworkStateListener netState) {
        this(netState, null);
    }

    public Class<? extends EntityComponent> getComponentType() {
        return BodyPosition.class;
    }

    public void initialize(EntityData ed) {
        this.ed = ed;
    }

    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        if (log.isTraceEnabled()) {
            log.trace("getComponent(" + entityId + ", " + type + ")");
        }
        if (!this.lastValues.containsKey(entityId)) {
            return null;
        }
        return (T)this.ed.getComponent(entityId, type);
    }

    public Set<EntityId> getEntityIds(ComponentFilter filter) {
        if (log.isTraceEnabled()) {
            log.trace("getEntityIds(" + filter + ")");
        }
        if (filter != null) {
            throw new UnsupportedOperationException("Filtering + body visibility not yet supported");
        }
        return this.lastValues.keySet();
    }

    public boolean collectChanges(Queue<EntityChange> updates) {
        Set active = this.netState.getActiveIds();
        boolean changed = false;
        if (log.isTraceEnabled()) {
            log.trace("active:" + active);
            log.trace("updates before:" + updates);
        }
        Iterator<Object> it = updates.iterator();
        while (it.hasNext()) {
            EntityChange change = (EntityChange)it.next();
            if (change.getComponentType() != BodyPosition.class || active.contains(change.getEntityId().getId())) continue;
            if (log.isTraceEnabled()) {
                log.trace("removing irrelevant change:" + change);
            }
            it.remove();
        }
        it = this.lastValues.keySet().iterator();
        while (it.hasNext()) {
            EntityId id = (EntityId)it.next();
            if (active.contains(id.getId())) continue;
            if (log.isTraceEnabled()) {
                log.trace("removing:" + id);
            }
            updates.add(new EntityChange(id, BodyPosition.class));
            it.remove();
            changed = true;
        }
        for (Long l : active) {
            EntityId id = new EntityId(l.longValue());
            if (this.lastValues.containsKey(id)) continue;
            if (log.isTraceEnabled()) {
                log.trace("adding:" + id);
            }
            BodyPosition pos = (BodyPosition)this.ed.getComponent(id, BodyPosition.class);
            this.lastValues.put(id, pos);
            updates.add(new EntityChange(id, (EntityComponent)pos));
            changed = true;
        }
        if (changed && log.isTraceEnabled()) {
            log.trace("done collectChanges() " + active);
        }
        return changed;
    }
}

