/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.ParentIdFileFunction;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.ColumnStates;
import com.simsilica.mworld.tile.io.ColumnStatesProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStatesDb
extends SpoolingObjectDb<TileId, ColumnStates> {
    static Logger log = LoggerFactory.getLogger(ColumnStatesDb.class);
    private File root;
    private ColumnStatesProtocol stateProtocol = new ColumnStatesProtocol();
    private Function<TileId, File> fileFunc;

    public ColumnStatesDb(File root) {
        this(root, ".state");
    }

    public ColumnStatesDb(File root, String extension) {
        this.root = root;
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        this.fileFunc = new ParentIdFileFunction<TileId>(root, extension);
    }

    public boolean markDirty(ColumnId colId) {
        ColumnStates states;
        TileId tileId = colId.getTileId();
        if (log.isTraceEnabled()) {
            log.trace("markDirty(" + colId + ") in tile:" + tileId);
        }
        if ((states = (ColumnStates)this.get(tileId)).markDirty(colId)) {
            log.info("Need to store column state for:" + tileId);
            this.update(tileId, states);
            return true;
        }
        return false;
    }

    @Override
    protected ColumnStates loadObject(TileId id) {
        File f;
        if (log.isTraceEnabled()) {
            log.trace("loadObject(" + id + ")");
        }
        if ((f = this.fileFunc.apply(id)).exists()) {
            return this.readStatesFile(f);
        }
        if (log.isTraceEnabled()) {
            log.trace("new ColumnStates(" + id + ")");
        }
        return new ColumnStates(id);
    }

    @Override
    protected void storeObject(TileId id, ColumnStates states) {
        File f = this.fileFunc.apply(id);
        log.info("writing states:" + states + " to:" + f);
        this.writeStatesFile(f, states);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ColumnStates readStatesFile(File f) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            ColumnStates columnStates = this.stateProtocol.read(in);
            return columnStates;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading column states file:" + f, e);
        }
    }

    protected void writeStatesFile(File f, ColumnStates states) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            this.stateProtocol.write(states, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing column states:" + f, e);
        }
        long end = System.nanoTime();
        if (log.isTraceEnabled()) {
            log.trace("Wrote [" + states + "] in " + (double)(end - start) / 1000000.0 + " ms");
        }
    }
}

