/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TileImageData;
import com.simsilica.mworld.tile.TileManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tile {
    static Logger log = LoggerFactory.getLogger(Tile.class);
    private TileManager tileManager;
    private TileId id;
    private Resolution resolution;
    private Map<Object, Object> layers = new HashMap<Object, Object>();

    public Tile(TileManager tileManager, TileId id, Resolution resolution) {
        this.tileManager = tileManager;
        this.id = id;
        this.resolution = resolution;
    }

    public TileId getTileId() {
        return this.id;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void put(Object key, Object layer) {
        this.layers.put(key, layer);
    }

    public <T> T get(Class<T> type) {
        return this.get(type, type);
    }

    public <T> T get(Object key, Class<T> type) {
        Object result = this.layers.get(key);
        return type.cast(result);
    }

    public void setImageData(ColumnId colId, Tile from) {
        log.info("setImageData(" + colId + ", " + from + ")");
        Vec3i start = colId.getTileLocal(null);
        for (Map.Entry<Object, Object> entry : this.layers.entrySet()) {
            TileImageData source;
            if (!(entry.getValue() instanceof TileImageData)) continue;
            TileImageData target = (TileImageData)entry.getValue();
            if (target == (source = (TileImageData)from.layers.get(entry.getKey()))) {
                log.info("target and source are same instance for:" + entry);
                continue;
            }
            log.info("Copying data from:" + source + " to:" + target);
            target.setData(source, start.x, start.z, 32, 32);
        }
    }

    public String toString() {
        return "Tile[id=" + this.getTileId() + ", resolution=" + (Object)((Object)this.resolution) + "]";
    }
}

