/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.account.base.json;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.simsilica.account.base.AccountStorage;
import com.simsilica.account.base.DefaultAccount;
import com.simsilica.account.base.json.MapValueTypeAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAccountStorage
implements AccountStorage {
    static Logger log = LoggerFactory.getLogger(JsonAccountStorage.class);
    public static final int FORMAT_VERSION = 1;
    private static final String FORMAT_PROPERTY = "_json_format_version";
    private Gson indexGson;
    private Gson accountGson;
    private File root;
    private Map<String, String> index;
    private Function<String, String> cleaner = new FileNameFilter();

    public JsonAccountStorage(File root, Class ... valueTypes) {
        this.root = root;
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        this.indexGson = gsonBuilder.create();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new MapValueTypeAdapterFactory(Map.class, valueTypes));
        this.accountGson = gsonBuilder.create();
        this.initIndex();
    }

    protected File toFile(String userId) {
        return new File(this.root, this.cleaner.apply(userId) + ".json");
    }

    @Override
    public boolean exists(String userId) {
        String globalUserId = this.index.get(userId);
        if (globalUserId == null) {
            return false;
        }
        File f = this.toFile(globalUserId);
        return f.exists();
    }

    @Override
    public DefaultAccount load(String userId) {
        String globalUserId = this.index.get(userId);
        if (globalUserId == null) {
            return null;
        }
        File f = this.toFile(globalUserId);
        if (!f.exists()) {
            return null;
        }
        try {
            DefaultAccount account = this.loadAccount(f);
            account.setProperty(FORMAT_PROPERTY, null);
            return account;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    @Override
    public void store(DefaultAccount account) {
        File f = this.toFile(account.getGlobalUserId());
        account.setProperty(FORMAT_PROPERTY, 1);
        try {
            this.storeAccount(f, account);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
        this.index.put(account.getUserId(), account.getGlobalUserId());
        this.index.put(account.getGlobalUserId(), account.getGlobalUserId());
        try {
            this.storeIndex();
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing user index", e);
        }
    }

    protected void upgrade(DefaultAccount account) {
    }

    protected DefaultAccount loadAccount(File f) throws IOException {
        String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
        DefaultAccount account = (DefaultAccount)this.accountGson.fromJson(json, DefaultAccount.class);
        this.upgrade(account);
        return account;
    }

    protected synchronized void storeAccount(File f, DefaultAccount account) throws IOException {
        String json = this.accountGson.toJson((Object)account);
        File temp = new File(f.getParentFile(), f.getName() + ".new");
        Files.write((CharSequence)json, (File)temp, (Charset)Charsets.UTF_8);
        if (f.exists()) {
            f.delete();
        }
        if (!temp.renameTo(f)) {
            throw new IOException("Error renaming:" + temp + " to:" + f);
        }
    }

    protected synchronized void storeIndex() throws IOException {
        File f = new File(this.root, "user.index");
        File temp = new File(this.root, "user.index.new");
        String json = this.indexGson.toJson(this.index);
        Files.write((CharSequence)json, (File)temp, (Charset)Charsets.UTF_8);
        if (f.exists()) {
            f.delete();
        }
        if (!temp.renameTo(f)) {
            throw new IOException("Error renaming:" + temp + " to:" + f);
        }
    }

    protected void initIndex() {
        File f = new File(this.root, "user.index");
        if (!f.exists()) {
            this.index = new HashMap<String, String>();
            return;
        }
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            Type mapType = new TypeToken<Map<String, String>>(){}.getType();
            this.index = new HashMap<String, String>((Map)this.indexGson.fromJson(json, mapType));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading user index", e);
        }
    }

    public static class FileNameFilter
    implements Function<String, String> {
        @Override
        public String apply(String s) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (c == '_') {
                    sb.append(c);
                    continue;
                }
                if (c == '-') {
                    sb.append(c);
                    continue;
                }
                if (c == '@') {
                    sb.append(c);
                    continue;
                }
                if (c != '.') continue;
                sb.append(c);
            }
            return sb.toString();
        }
    }
}

