/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.simsilica.mod.FileModPack;
import com.simsilica.mod.ModManager;
import com.simsilica.mphys.DynArray;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerModsSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(ServerModsSystem.class);
    private ModManager modManager;
    private DynArray<FileModPack> fileMods = new DynArray(FileModPack.class);
    private double checkInterval;
    private double nextCheck;

    public ServerModsSystem(ModManager modManager, double checkInterval) {
        this.modManager = modManager;
        this.checkInterval = checkInterval;
    }

    public void loadModFiles(File modRoot) throws IOException {
        log.info("Checking:" + modRoot.getCanonicalPath());
        if (!modRoot.exists()) {
            log.info("Creating:" + modRoot);
            modRoot.mkdirs();
        }
        for (File f : modRoot.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".mod.json")) continue;
            log.info("Loading modpack:" + f);
            this.fileMods.add((Object)this.modManager.loadModPack(f));
        }
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    public void start() {
    }

    public void update(SimTime time) {
        double t = time.getTimeInSeconds();
        if (t > this.nextCheck) {
            this.nextCheck = t + this.checkInterval;
            this.checkMods();
        }
    }

    public void stop() {
    }

    protected void checkMods() {
        for (FileModPack mod : (FileModPack[])this.fileMods.getArray()) {
            if (!mod.hasChanged()) continue;
            log.info("Reloading:" + mod);
            try {
                mod.reload();
            }
            catch (Exception e) {
                log.error("Error reloading:" + mod, (Throwable)e);
            }
        }
    }
}

