/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.base.EntityIdGenerator;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.es.sql.SqlSession;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PersistentEntityIdGenerator
implements EntityIdGenerator {
    private SqlEntityData parent;
    private String tableName = "ENTITY_ID";
    private long entityId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistentEntityIdGenerator(SqlEntityData parent) throws SQLException {
        this.parent = parent;
        SqlSession session = parent.getSession();
        DatabaseMetaData md = session.getConnection().getMetaData();
        try (ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);){
            if (rs.next()) {
                this.loadId(session);
                return;
            }
        }
        StringBuilder sb = new StringBuilder("CREATE");
        sb.append(" CACHED TABLE");
        sb.append(" " + this.tableName + "\n");
        sb.append("(\n");
        sb.append("  id TINYINT,\n");
        sb.append("  entityId BIGINT");
        sb.append("\n)");
        Statement st = session.getConnection().createStatement();
        st.executeUpdate(sb.toString());
        String sql = "INSERT INTO " + this.tableName + "(id,entityId) VALUES (0,0)";
        int i = st.executeUpdate(sql);
        if (i != 1) {
            throw new SQLException("Error initializing sequence table:" + sb);
        }
        st.close();
    }

    public static PersistentEntityIdGenerator create(SqlEntityData parent) throws SQLException {
        return new PersistentEntityIdGenerator(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadId(SqlSession session) throws SQLException {
        try (Statement st = session.getConnection().createStatement();){
            ResultSet rs = st.executeQuery("SELECT entityId from " + this.tableName + " where id=0");
            if (rs.next()) {
                this.entityId = rs.getLong(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long nextEntityId() {
        long l;
        long result = this.entityId++;
        SqlSession session = this.parent.getSession();
        Statement st = session.getConnection().createStatement();
        try {
            String sql = "UPDATE " + this.tableName + " SET entityId=" + this.entityId + " WHERE id=0";
            int update = st.executeUpdate(sql);
            if (update != 1) {
                throw new SQLException("EntityID sequence not updated.");
            }
            l = result;
        }
        catch (Throwable throwable) {
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new RuntimeException("Error persisting entity ID", e);
            }
        }
        st.close();
        return l;
    }
}

