/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.fsm.StateMachine;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.InsetsComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mworld.World;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.ProgressState;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.NewWorldPreloader;
import mythruna.client.net.WorldPreloader;
import mythruna.client.net.character.CharacterEditor;
import mythruna.client.net.character.CharacterViewState;
import mythruna.client.net.character.MapEntity;
import mythruna.client.sound.SoundState;
import mythruna.client.ui.CreditsState;
import mythruna.fabric.FabricConfig;
import mythruna.fabric.ShapeConfig;
import mythruna.net.AccountSession;
import mythruna.net.CharacterSession;
import mythruna.net.DataSession;
import mythruna.world.WorldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobbyState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(LobbyState.class);
    private boolean singlePlayer;
    private StateMachine<String, String> fsm;
    private Container window;
    private Container charMgr;
    private ListBox<Entity> characterList;
    private VersionedReference<Integer> selectedCharRef;
    private Label worldName;
    private World world;
    private WorldInfo worldInfo;
    private EntityData ed;
    private EntityId player;
    private CharacterContainer charContainer;
    private VersionedList<Entity> characters = new VersionedList();
    private CharacterEditor editor;
    private CreditsState blurbs;
    private CharacterViewState viewState;

    public LobbyState(WorldInfo worldInfo, boolean singlePlayer, StateMachine<String, String> fsm) {
        this(singlePlayer, fsm);
        this.worldInfo = worldInfo;
    }

    public LobbyState(boolean singlePlayer, StateMachine<String, String> fsm) {
        this.fsm = fsm;
        this.singlePlayer = singlePlayer;
        this.setEnabled(false);
    }

    public EntityData getEntityData() {
        return ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
    }

    public CharacterViewState getViewState() {
        return this.viewState;
    }

    protected void play(Entity character) {
        log.info("play(" + character + ")");
        this.fsm.trigger((Object)"play", (Object)character.getId());
        SoundState sounds = (SoundState)this.getState(SoundState.class);
        if (!sounds.isPlaying("Loading Music")) {
            sounds.playMusic("Loading Music", 1.0f);
        }
        this.startBlurbs();
        String mainProgress = "Entering world...";
        ((ProgressState)this.getState(ProgressState.class)).setMainThreadFilter(thread -> {
            ProgressTrackers.ThreadTrackers trackers = ProgressTrackers.getThreadTrackers((Thread)thread);
            log.info("trackers:" + trackers);
            for (ProgressTracker tracker : trackers) {
                log.info("Checking:" + tracker.getName() + " against:Entering world...");
                if (!"Entering world...".equals(tracker.getName())) continue;
                return true;
            }
            return false;
        });
        ((ProgressState)this.getState(ProgressState.class)).openView((Object)this, "Entering world...");
        ((ProgressState)this.getState(ProgressState.class)).setSplash("Splash/loading1.jpg");
        WorldPreloader preloader = new WorldPreloader(character.getId(), (ConnectionState)this.getState(ConnectionState.class));
        preloader.onDone(error -> {
            if (error != null) {
                this.stopBlurbs();
                ((ProgressState)this.getState(ProgressState.class)).releaseView((Object)this);
                this.fsm.trigger((Object)"failure", error);
                return;
            }
            log.info("Starting real game session...");
            sounds.stopAll(5.0f);
            this.getStateManager().attach((AppState)new GameSessionState(preloader, this.singlePlayer));
            this.getApplication().enqueue(() -> this.closeProgressView(3));
        });
        ((JobState)this.getState(JobState.class)).execute((Job)preloader, 0);
    }

    protected void preloadNewWorld() {
        if (!this.singlePlayer) {
            return;
        }
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class, false);
        if (host == null) {
            log.warn("Cannot preload new world without a HostedGameState.");
            return;
        }
        final NewWorldPreloader loader = new NewWorldPreloader(host.getWorldManager());
        ((JobState)this.getState("backgroundWorkers", JobState.class)).execute(new Job(){

            public void runOnWorker() {
                loader.run();
            }

            public double runOnUpdate() {
                return 0.0;
            }
        }, 1);
    }

    protected void closeProgressView(int left) {
        log.info("closeProgressView(" + left + ")");
        if (left > 0) {
            this.getApplication().enqueue(() -> this.closeProgressView(left - 1));
            return;
        }
        ((ProgressState)this.getState(ProgressState.class)).releaseView((Object)this);
        ((ProgressState)this.getState(ProgressState.class)).setMainThreadFilter(null);
        this.stopBlurbs();
    }

    protected void startBlurbs() {
        if (this.getStateManager().hasState((AppState)this.blurbs)) {
            return;
        }
        this.getStateManager().attach((AppState)this.blurbs);
    }

    protected void stopBlurbs() {
        this.getStateManager().detach((AppState)this.blurbs);
    }

    protected void exit() {
        log.info("exit");
        this.fsm.trigger((Object)"exit");
    }

    protected void createCharacter() {
        log.info("createCharacter()");
        this.editor.setCharacter(new MapEntity());
        this.updateListVisibility();
    }

    protected void doCreateCharacter() {
        log.info("doCreateCharacter()");
    }

    public void setPlayer(String userId) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        this.world = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)userId);
        this.setPlayer(this.ed.findEntity(filter, new Class[]{Name.class}));
        if (this.player == null) {
            throw new IllegalArgumentException("Player not found:" + userId);
        }
    }

    public void setPlayer(EntityId player) {
        log.info("setPlayer(" + player + ")");
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        this.world = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
        this.player = player;
        this.updateInfo();
    }

    protected void updateInfo() {
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        final EntityId worldEntity = account.getWorldEntity();
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private Name name;

            public void runOnWorker() {
                this.name = (Name)LobbyState.this.ed.getComponent(worldEntity, Name.class);
            }

            public double runOnUpdate() {
                LobbyState.this.worldName.setText("World: " + this.name.getName());
                return 0.0;
            }
        });
    }

    protected void initialize(Application app) {
        this.viewState = new CharacterViewState();
        app.getStateManager().attach((AppState)this.viewState);
        this.window = new Container((GuiLayout)new BorderLayout(), new ElementId("window"));
        this.charMgr = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even));
        this.window.addChild((Node)this.charMgr, new Object[]{BorderLayout.Position.West});
        this.charMgr.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "createCharacter")), new Object[0]);
        this.charMgr.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "exit")), new Object[0]);
        this.characterList = (ListBox)this.charMgr.addChild((Node)new ListBox(this.characters), new Object[0]);
        this.characterList.setVisibleItems(10);
        this.characterList.setCellRenderer((ValueRenderer)new CharacterRenderer(this));
        this.selectedCharRef = this.characterList.getSelectionModel().createSelectionReference();
        this.charMgr.addChild((Node)new Label(""), new Object[0]);
        this.worldName = (Label)this.window.addChild((Node)new Label("World Name", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        this.worldName.setTextHAlignment(HAlignment.Center);
        Vector2f size = ((GuiState)this.getState(GuiState.class)).getGuiSize();
        Vector3f pref = this.window.getPreferredSize().clone();
        pref.x = Math.max(size.x * 0.9f, pref.x);
        pref.y = Math.max(size.y * 0.9f, pref.y);
        this.window.setPreferredSize(pref);
        this.editor = new CharacterEditor(this);
        this.editor.setInsetsComponent((InsetsComponent)new DynamicInsetsComponent(0.0f, 0.5f, 0.0f, 0.5f));
        this.window.addChild((Node)this.editor, new Object[]{BorderLayout.Position.Center});
        this.blurbs = new CreditsState();
        String[] messages = new String[]{"When entering a new world for the first time\nloading can take a while.", "Town and village placement is purely random and not finalized.", "The frequency of points of interest is overly chaotic\n...and placement is sometimes just weird.", "For a new world, it may take a while before far generation settles\nand the game may feel sluggish during that time.", "While playing, additional far-generation progress will be shown in the lower right corner.", "Thanks for playing the game!!!", "Thanks for waiting for the world generation to complete."};
        List<String> list = Arrays.asList(messages);
        List<String> sublist = list.subList(1, messages.length - 1);
        Collections.shuffle(sublist);
        double duration = 9.0;
        double nextTime = 1.0;
        for (String s : messages) {
            this.blurbs.addCredit(s, nextTime, nextTime + duration, 0.5, 0.1);
            nextTime += duration;
        }
    }

    protected void cleanup(Application app) {
        app.getStateManager().detach((AppState)this.viewState);
    }

    protected void onEnable() {
        FabricConfig.loadAssets((AssetManager)this.getApplication().getAssetManager());
        ShapeConfig.loadAssets((AssetManager)this.getApplication().getAssetManager());
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window);
        this.charContainer = new CharacterContainer(this.ed, this.player);
        this.charContainer.start();
        Locale locale = Locale.getDefault();
        log.info("Current locale:" + locale);
        DataSession dataSession = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(DataSession.class);
        dataSession.setLocale(locale.getCountry());
        CharacterSession charSession = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(CharacterSession.class);
        this.editor.initialize(charSession, dataSession);
        this.preloadNewWorld();
    }

    public void update(float tpf) {
        this.charContainer.update();
        if (this.selectedCharRef.update()) {
            Entity entity = (Entity)this.characterList.getSelectedItem();
            if (entity != null) {
                this.editor.setCharacter(new MapEntity(entity));
            } else {
                this.editor.setCharacter(null);
            }
            this.updateListVisibility();
        }
    }

    protected void onDisable() {
        this.window.removeFromParent();
        this.charContainer.stop();
    }

    public void checkCancelEdit(String message) {
        ((OptionPanelState)this.getState(OptionPanelState.class)).show("Really cancel?", message, new Action[]{new CallMethodAction("Yes", (Object)this, "cancelEdit"), new EmptyAction("No"), new EmptyAction("Cancel")});
    }

    public void cancelEdit() {
        log.info("Cancel edit");
        this.characterList.getSelectionModel().clear();
        this.editor.setCharacter(null);
        this.updateListVisibility();
    }

    public void saveEditAndPlay() {
        this.saveCharacter();
        this.play(this.editor.getCharacter());
    }

    public void saveCharacter() {
        MapEntity character = this.editor.getCharacter();
        CharacterSession session = ((ConnectionState)this.getState(ConnectionState.class)).getService(CharacterSession.class);
        if (character.getId() == null) {
            Name name = character.get(Name.class);
            EntityId id = session.createCharacter(name.getName(), character.getComponents());
            character.setId(id);
        } else {
            session.updateCharacter(character.getId(), character.getComponents());
        }
    }

    protected void updateListVisibility() {
        if (this.editor.isReadOnly() && this.charMgr.getParent() == null) {
            this.window.addChild((Node)this.charMgr, new Object[]{BorderLayout.Position.West});
        } else if (!this.editor.isReadOnly() && this.charMgr.getParent() != null) {
            this.window.removeChild((Node)this.charMgr);
        }
    }

    private class CharacterRenderer
    extends DefaultValueRenderer<Entity> {
        private CharacterRenderer(LobbyState lobbyState) {
        }

        protected String valueToString(Entity value) {
            return ((Name)value.get(Name.class)).getName();
        }

        public Panel getView(Entity value, boolean selected, Panel existing) {
            Panel result = super.getView((Object)value, selected, existing);
            return result;
        }
    }

    private class CharacterContainer
    extends EntityContainer<Entity> {
        private final Comparator<Entity> comparator;

        public CharacterContainer(EntityData ed, EntityId player) {
            super(ed, Filters.fieldEquals(CreatedBy.class, (String)"creatorId", (Object)player), new Class[]{CreatedBy.class, Name.class});
            this.comparator = new EntityNameComparator(LobbyState.this);
        }

        protected Entity addObject(Entity e) {
            int index = Collections.binarySearch(LobbyState.this.characters, e, this.comparator);
            if (index < 0) {
                index = -(index + 1);
            }
            LobbyState.this.characters.add(index, (Object)e);
            return e;
        }

        protected void updateObject(Entity object, Entity e) {
        }

        protected void removeObject(Entity object, Entity e) {
            LobbyState.this.characters.remove((Object)e);
        }
    }

    private class EntityNameComparator
    implements Comparator<Entity> {
        private EntityNameComparator(LobbyState lobbyState) {
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            String n1 = ((Name)e1.get(Name.class)).getName();
            String n2 = ((Name)e2.get(Name.class)).getName();
            return n1.compareTo(n2);
        }
    }
}

