/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mblock.CellArray;
import mythruna.client.ui.clothing.ClothingBuilder;
import mythruna.client.ui.edit.Edit;
import mythruna.fabric.FabricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchReplaceEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(SearchReplaceEdit.class);
    private ClothingBuilder builder;
    private int findType;
    private int replaceType;

    public SearchReplaceEdit(ClothingBuilder builder, int findType, int replaceType) {
        this.builder = builder;
        this.findType = findType;
        this.replaceType = replaceType;
    }

    @Override
    public String toDisplay() {
        return this.findType + "->" + this.replaceType;
    }

    @Override
    public void doEdit() {
        this.doReplace(this.findType, this.replaceType);
    }

    @Override
    public void undoEdit() {
        this.doReplace(this.replaceType, this.findType);
    }

    protected void doReplace(int find, int replace) {
        CellArray cells = this.builder.getCells();
        boolean changed = false;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int val;
                for (int k = 0; k < 32 && (val = cells.getCell(i, j, k)) != 0; ++k) {
                    int type = FabricUtils.toFabric((int)val);
                    if (type != find) continue;
                    log.info("Found:" + type + "  replacing with:" + replace);
                    int shape = FabricUtils.toShape((int)val);
                    int newVal = FabricUtils.toCell((int)shape, (int)replace);
                    cells.setCell(i, j, k, newVal);
                    changed = true;
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

