/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.GameSessionState;
import mythruna.client.ui.map.CustomLineLayer;
import mythruna.client.ui.map.CustomMarkerLayer;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.IconSet;
import mythruna.client.ui.map.MapPoint;
import mythruna.client.ui.map.MapRootComponent;
import mythruna.client.ui.map.MapToolLayer;
import mythruna.client.ui.map.MapViewState;
import mythruna.client.ui.map.MeasureToolLayer;
import mythruna.client.view.AvatarState;
import mythruna.es.MapToolType;
import mythruna.es.ObjectName;
import mythruna.shape.IconName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapToolState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MapToolState.class);
    private EntityData ed;
    private BackgroundRetrieverState retriever;
    private MapViewState map;
    private ViewPortListener viewPortListener = new ViewPortListener();
    private MapCursorListener mapListener = new MapCursorListener();
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Double> mapRadiusRef;
    private TileId centerId;
    private VersionedHolder<List<TileId>> visibleTiles = new VersionedHolder(new ArrayList());
    private MapRootComponent toolRoot = new MapRootComponent("toolRoow");
    private ToolContainer tools;
    private boolean toolBarInvalid;
    private Container toolBar;
    private Tool selectedTool;
    private Container layerEditor;
    private boolean isRunning = false;
    private Map<String, MapToolLayer> toolLayers = new HashMap<String, MapToolLayer>();
    private MapToolLayer activeToolLayer = null;
    private MapToolLayer defaultLayer = new DefaultMapToolLayer();
    private IconSet icons;

    public IconSet getIcons() {
        return this.icons;
    }

    public VersionedReference<List<TileId>> createVisibleTilesRef() {
        return this.visibleTiles.createReference();
    }

    public void setMapToolLayer(String layerType, MapToolLayer layer) {
        MapToolLayer existing = this.toolLayers.put(layerType, layer);
        if (this.isRunning) {
            layer.start();
            if (existing != null && !this.toolLayers.values().contains(existing)) {
                existing.stop();
            }
        }
        if (this.tools != null) {
            for (Tool tool : this.tools.getArray()) {
                tool.resetMapToolLayer();
            }
        }
        this.resetActiveToolLayer();
    }

    public MapToolLayer getMapToolLayer(String layerType) {
        MapToolLayer result = this.toolLayers.get(layerType);
        return result != null ? result : this.defaultLayer;
    }

    public Node getMapRoot() {
        return this.map.getMapView();
    }

    public Node getToolRoot() {
        return this.toolRoot.getLayerRoot();
    }

    public MapPoint createMapPoint(Vec3d world) {
        return new MapPoint(world, this.toolRoot.getWorldCenter(), this.toolRoot.getScale());
    }

    public Vector2f getViewRadius() {
        Vector3f size = this.toolRoot.getLayerSize();
        return new Vector2f(size.x * 0.5f, size.y * 0.5f);
    }

    public void setLayerEditor(Panel p) {
        this.layerEditor.clearChildren();
        if (p != null) {
            this.layerEditor.addChild((Node)p, new Object[0]);
        }
    }

    public EntityId getEntityIdForCollision(Spatial collision) {
        for (Tool tool : this.tools.getArray()) {
            EntityId result;
            if (tool.layer == null || (result = tool.layer.getEntityIdForCollision(collision)) == null) continue;
            return result;
        }
        return null;
    }

    protected void initialize(Application app) {
        GameSessionState session = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = session.getEntityData();
        this.retriever = (BackgroundRetrieverState)this.getState(BackgroundRetrieverState.class, true);
        this.map = (MapViewState)this.getState(MapViewState.class);
        this.map.addLayer(this.toolRoot);
        this.icons = new IconSet(this.ed, session.getWorldEntity(), this.retriever);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.mapRadiusRef = this.map.getWorldRadiusRef();
        this.centerId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()));
        this.setMapToolLayer("measure", new MeasureToolLayer(this));
        this.setMapToolLayer("marker", new CustomMarkerLayer(session.getGameSession(), this.ed, this));
        this.setMapToolLayer("line", new CustomLineLayer(session.getGameSession(), this.ed, this, app.getAssetManager()));
        this.toolBar = new Container();
        this.map.addLeftPanel((Panel)this.toolBar);
        this.layerEditor = new Container();
        this.map.addLeftPanel((Panel)this.layerEditor);
        this.tools = new ToolContainer(this.ed);
        this.tools.start();
        this.updateToolBar();
        this.resetActiveToolLayer();
        this.updateViewPort();
        this.rebuildActiveTiles();
        log.info("adding listener to:" + this.map.getMapView().getControl(GuiControl.class));
        ((GuiControl)this.map.getMapView().getControl(GuiControl.class)).addListener((GuiControlListener)this.viewPortListener);
    }

    protected void cleanup(Application app) {
        ((GuiControl)this.map.getMapView().getControl(GuiControl.class)).removeListener((GuiControlListener)this.viewPortListener);
        this.tools.stop();
    }

    protected void onEnable() {
        CursorEventControl.addListenersToSpatial((Spatial)this.map.getMapView(), (CursorListener[])new CursorListener[]{this.mapListener});
        for (MapToolLayer layer : this.toolLayers.values()) {
            layer.start();
        }
        this.isRunning = true;
        this.icons.start();
    }

    protected void onDisable() {
        this.isRunning = false;
        CursorEventControl.removeListenersFromSpatial((Spatial)this.map.getMapView(), (CursorListener[])new CursorListener[]{this.mapListener});
        for (MapToolLayer layer : this.toolLayers.values()) {
            layer.stop();
        }
        this.icons.stop();
    }

    public void update(float tpf) {
        TileId tileId;
        boolean viewChanged = false;
        if (this.posRef.update() && (tileId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()))).getId() != this.centerId.getId()) {
            this.centerId = tileId;
            viewChanged = true;
        }
        if (this.mapRadiusRef.update()) {
            viewChanged = true;
        }
        if (viewChanged) {
            this.rebuildActiveTiles();
        }
        this.tools.update();
        if (this.toolBarInvalid) {
            this.updateToolBar();
        }
        for (Tool tool : this.tools.getArray()) {
            tool.layer.update();
        }
        this.icons.update();
    }

    protected void updateViewPort() {
        for (MapToolLayer layer : this.toolLayers.values()) {
            layer.updateViewPort(this.getViewRadius());
        }
    }

    protected void setSelectedTool(Tool selectedTool) {
        if (this.selectedTool == selectedTool) {
            return;
        }
        this.selectedTool = selectedTool;
        this.refreshToolSelection();
    }

    protected void refreshToolSelection() {
        if (this.selectedTool == null && this.tools.getArray().length > 0) {
            this.setSelectedTool(this.tools.getArray()[0]);
            return;
        }
        for (Tool type : this.tools.getArray()) {
            type.setSelected(type == this.selectedTool);
        }
        this.resetActiveToolLayer();
    }

    protected void updateToolBar() {
        log.info("updateToolBar()");
        this.toolBar.clearChildren();
        this.toolBar.addChild((Node)new Label("Tools:"), new Object[0]);
        for (Tool type : this.tools.getArray()) {
            log.info("Adding type:" + type.entity);
            this.toolBar.addChild((Node)type.button, new Object[0]);
        }
        this.toolBarInvalid = false;
        this.refreshToolSelection();
    }

    protected void rebuildActiveTiles() {
        log.info("rebuildActiveTiles() tile:" + this.centerId + "  radius:" + this.mapRadiusRef.get());
        Vec3i center = this.centerId.getWorld(null);
        int radius = (int)Math.round((Double)this.mapRadiusRef.get() / 1024.0);
        int size = radius * 2 + 1;
        log.info(" filter array size:" + size * size);
        ArrayList<TileId> tiles = new ArrayList<TileId>();
        boolean index = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Vec3i loc = center.add(x * 1024, 0, z * 1024);
                tiles.add(TileId.fromWorld((Vec3i)loc));
            }
        }
        this.visibleTiles.setObject(tiles);
    }

    protected void setActiveToolLayer(MapToolLayer activeToolLayer) {
        log.info("setActiveToolLayer(" + activeToolLayer + ") existing:" + this.activeToolLayer);
        if (this.activeToolLayer == activeToolLayer) {
            return;
        }
        if (this.activeToolLayer != null) {
            this.activeToolLayer.setActive(false);
        }
        this.activeToolLayer = activeToolLayer;
        if (this.activeToolLayer != null) {
            this.activeToolLayer.setActive(true);
        }
    }

    protected void resetActiveToolLayer() {
        if (this.tools == null) {
            this.setActiveToolLayer(this.defaultLayer);
            return;
        }
        if (this.selectedTool == null) {
            this.setActiveToolLayer(this.defaultLayer);
            return;
        }
        this.setActiveToolLayer(this.selectedTool.layer);
    }

    private class ViewPortListener
    extends AbstractGuiControlListener {
        private ViewPortListener() {
        }

        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            MapToolState.this.updateViewPort();
        }
    }

    private class MapCursorListener
    implements CursorListener {
        private Vector2f lastScreen;
        private Vec3d lastWorld = null;
        private Spatial lastCollision = null;
        private Vector2f screenPressLoc;
        private Vec3d worldPressLoc;
        private int clickDistance = 2;
        private int dragButton = -1;
        private Vec3d dragStart;
        private Spatial dragCollision;

        private MapCursorListener() {
        }

        protected Vec3d toWorld(CursorMotionEvent event) {
            Vector3f cp = event.getCollision().getContactPoint();
            Vector3f local = event.getTarget().worldToLocal(cp, null);
            return MapToolState.this.toolRoot.viewToWorld(local);
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.isPressed()) {
                this.screenPressLoc = this.lastScreen;
                this.worldPressLoc = this.lastWorld;
                this.dragButton = event.getButtonIndex();
                this.dragCollision = this.lastCollision;
            } else {
                if (this.dragStart == null) {
                    MapToolState.this.activeToolLayer.click(event.getButtonIndex(), this.lastWorld, this.lastCollision);
                } else {
                    MapToolState.this.activeToolLayer.endDrag(this.dragButton, this.dragStart, this.lastWorld, this.lastCollision);
                }
                this.screenPressLoc = null;
                this.worldPressLoc = null;
                this.dragStart = null;
                this.dragButton = -1;
                this.dragCollision = null;
            }
            MapToolState.this.activeToolLayer.button(event.getButtonIndex(), event.isPressed(), this.lastWorld, this.lastCollision);
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.lastCollision = event.getCollision() == null ? null : event.getCollision().getGeometry();
            this.lastScreen = event.getLocation();
            if (event.getCollision() != null) {
                this.lastWorld = this.toWorld(event);
            }
            if (this.dragStart == null && this.screenPressLoc != null && this.screenPressLoc.distance(this.lastScreen) > (float)this.clickDistance) {
                this.dragStart = this.worldPressLoc;
                MapToolState.this.activeToolLayer.startDrag(this.dragButton, this.dragStart, this.lastWorld, this.dragCollision);
            }
            if (this.dragStart != null) {
                MapToolState.this.activeToolLayer.drag(this.dragButton, this.dragStart, this.lastWorld, this.dragCollision);
            } else {
                MapToolState.this.activeToolLayer.hover(this.lastWorld, this.lastCollision);
            }
        }
    }

    private class ToolContainer
    extends EntityContainer<Tool> {
        public ToolContainer(EntityData ed) {
            super(ed, new Class[]{MapToolType.class, ObjectName.class});
        }

        public Tool[] getArray() {
            return (Tool[])super.getArray();
        }

        protected Tool addObject(Entity entity) {
            Tool result = new Tool(entity);
            this.updateObject(result, entity);
            MapToolState.this.refreshToolSelection();
            MapToolState.this.toolBarInvalid = true;
            return result;
        }

        protected void updateObject(Tool object, Entity entity) {
            object.update();
        }

        protected void removeObject(Tool object, Entity entity) {
            object.release();
            MapToolState.this.toolBarInvalid = true;
        }
    }

    private class Tool {
        private Entity entity;
        private MapToolType toolType;
        private String name;
        private String typeName;
        private IconName iconName;
        private Button button;
        private MapToolLayer layer;

        public Tool(Entity entity) {
            this.entity = entity;
            this.button = new Button("", new ElementId("toolbar.button"));
            this.layer = MapToolState.this.defaultLayer;
            this.button.addClickCommands(source -> MapToolState.this.setSelectedTool(this));
        }

        public void setSelected(boolean selected) {
            log.info("setSelected(" + selected + ") name:" + this.name);
            ColoredComponent cc = (ColoredComponent)this.button.getBackground();
            if (selected) {
                cc.setAlpha(1.0f);
            } else {
                cc.setAlpha(0.0f);
            }
        }

        protected void setName(String name) {
            this.button.setText(name);
        }

        protected void setTypeName(String typeName) {
            this.typeName = typeName;
            this.resetMapToolLayer();
        }

        protected void resetMapToolLayer() {
            this.layer = MapToolState.this.getMapToolLayer(this.typeName);
            this.layer.setToolId(this.entity.getId());
            MapToolState.this.resetActiveToolLayer();
        }

        protected void setIconName(String iconName) {
            this.iconName = IconName.parse((String)iconName);
            IconComponent ic = new IconComponent(this.iconName.getImageName());
            ic.setColor(new ColorRGBA(0.08f, 0.08f, 0.16f, 0.9f));
            this.button.setIcon((GuiComponent)ic);
        }

        public void update() {
            this.toolType = (MapToolType)this.entity.get(MapToolType.class);
            ObjectName on = (ObjectName)this.entity.get(ObjectName.class);
            MapToolState.this.retriever.getString(on.getNameId(), this::setName);
            MapToolState.this.retriever.getString(this.toolType.getTypeId(), this::setTypeName);
            MapToolState.this.retriever.getString(this.toolType.getIconId(), this::setIconName);
        }

        public void release() {
        }
    }
}

