/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.BlockIterator;
import java.util.Iterator;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldHit;
import mythruna.client.view.object.ModelViewState;
import mythruna.client.view.object.PickedObject;
import mythruna.sim.BlockHit;
import mythruna.sim.ObjectHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PickState.class);
    private AvatarState avatar;
    private ModelViewState models;

    public WorldHit pickWorld(int maxDistance) {
        Rayd view = this.avatar.getViewRay();
        return this.pickWorld(view, maxDistance);
    }

    public WorldHit pickWorld(Vec3d dir, int maxDistance) {
        Rayd view = this.avatar.getViewRay(dir);
        return this.pickWorld(view, maxDistance);
    }

    public WorldHit pickWorld(Vec3d offset, Vec3d dir, int maxDistance) {
        Rayd view = this.avatar.getViewRay(offset, dir);
        return this.pickWorld(view, maxDistance);
    }

    public WorldHit pickWorld(Rayd view, int maxDistance) {
        WorldHit result = new WorldHit();
        Vec3d place = null;
        Vec3d angle = null;
        Iterator<BlockIterator.Intersection> it = this.avatar.pick(view, maxDistance);
        if (it.hasNext()) {
            BlockIterator.Intersection hit = it.next();
            if (log.isDebugEnabled()) {
                log.debug("hit:" + hit);
            }
            double blockDistance = Math.ceil(view.getOrigin().distance(hit.getPoint()));
            if (log.isDebugEnabled()) {
                log.debug("blockDistance:" + blockDistance + "  hit:" + hit.getType() + "  normal:" + hit.getNormal());
            }
            if (blockDistance <= (double)maxDistance) {
                result.block = new BlockHit(hit.getPoint(), hit.getBlock(), hit.getType(), hit.getCellValue(), hit.getNormal());
                place = hit.getPoint();
                angle = hit.getNormal();
                if (log.isDebugEnabled()) {
                    log.debug("origin:" + view.getOrigin());
                    log.debug("hit:" + place);
                    log.debug("maxDistance:" + view.getOrigin().distance(place));
                }
                maxDistance = (int)Math.max(1.0, blockDistance);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Need to check for object hits from:" + view + "  limit:" + maxDistance);
        }
        PickedObject picked = this.models.pickObject(this.avatar.getAvatarId(), view.getOrigin(), view.getDirection(), maxDistance);
        if (log.isDebugEnabled()) {
            log.debug("Found:" + picked);
        }
        result.object = picked != null ? new ObjectHit(picked.entityId, picked.location, picked.normal) : null;
        return result;
    }

    protected void initialize(Application app) {
        this.avatar = (AvatarState)this.getState(AvatarState.class, true);
        this.models = (ModelViewState)this.getState(ModelViewState.class, true);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }
}

