/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.asset.AssetManager;
import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.LightUtils;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import mythruna.client.view.object.AbstractModel;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelFactory;
import mythruna.client.view.object.SpatialUtils;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J3oModelFactory
implements ModelFactory {
    static Logger log = LoggerFactory.getLogger(J3oModelFactory.class);
    private AssetManager assets;
    private JobState workers;

    public J3oModelFactory(AssetManager assets, JobState workers) {
        this.assets = assets;
        this.workers = workers;
    }

    @Override
    public Model createModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
        J3oModelImpl result = new J3oModelImpl(this, entityId, name, shapeInfo);
        this.workers.execute((Job)new ModelLoader(result, name, shapeInfo), -1);
        return result;
    }

    protected class J3oModelImpl
    extends AbstractModel {
        private ColorRGBA localLighting = new ColorRGBA();

        public J3oModelImpl(J3oModelFactory this$0, EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
            super(entityId, name, shapeInfo);
        }

        @Override
        protected void updateSpatial(Spatial spatial) {
            super.updateSpatial(spatial);
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "LocalLighting", (Object)this.localLighting));
            spatial.setCullHint(Spatial.CullHint.Always);
        }

        @Override
        public void setLighting(int lighting) {
            float s = (float)LightUtils.sun((int)lighting) / 15.0f;
            float r = (float)LightUtils.red((int)lighting) / 15.0f;
            float g = (float)LightUtils.green((int)lighting) / 15.0f;
            float b = (float)LightUtils.blue((int)lighting) / 15.0f;
            this.localLighting.set(r, g, b, s);
        }

        @Override
        public Vec3d getCenterOffset() {
            return Vec3d.ZERO;
        }
    }

    protected class ModelLoader
    implements Job {
        private final J3oModelImpl target;
        private final ShapeName name;
        private final ShapeInfo shapeInfo;
        private Spatial spatial;

        public ModelLoader(J3oModelImpl target, ShapeName name, ShapeInfo shapeInfo) {
            this.target = target;
            this.name = name;
            this.shapeInfo = shapeInfo;
        }

        public void runOnWorker() {
            try {
                String assetName = this.name.getFullName();
                this.spatial = J3oModelFactory.this.assets.loadModel(assetName);
                this.spatial.setUserData("oid", (Object)this.target.getEntityId().getId());
                this.spatial.setLocalScale((float)this.shapeInfo.getScale());
            }
            catch (Exception e) {
                log.error("Error loading:" + this.name + " for:" + this.target, (Throwable)e);
                this.spatial = SpatialUtils.createDebugSphere("bad:" + this.target.getEntityId(), (float)this.shapeInfo.getScale(), ColorRGBA.Red, null);
            }
        }

        public double runOnUpdate() {
            this.target.updateSpatial(this.spatial);
            return 0.1;
        }
    }
}

