/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeGridCellIndex;
import com.simsilica.bpos.LargeObject;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.GridComponentIndex;
import com.simsilica.es.SpatialEntityContainer;
import com.simsilica.es.SpawnPositionIndex;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.trans.TransitionBuffer;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.transaction.CellEdit;
import com.simsilica.state.DebugHudState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mythruna.GameConstants;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.GameSessionState;
import mythruna.client.MythrunaConfig;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.TimeState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldViewState;
import mythruna.client.view.object.DefaultModelFactory;
import mythruna.client.view.object.FaxModelFactory;
import mythruna.client.view.object.J3oModelFactory;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelCounts;
import mythruna.client.view.object.ModelListener;
import mythruna.client.view.object.PickedObject;
import mythruna.client.view.object.RigModelFactory;
import mythruna.client.view.object.SpatialFactory;
import mythruna.client.view.object.SpatialUtils;
import mythruna.client.view.object.TemporaryView;
import mythruna.client.view.object.TypeBasedModelFactory;
import mythruna.net.GameSession;
import mythruna.net.client.DestructibleSessionClientService;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelViewState.class);
    private static final long VISIBILITY_DELAY = 100000000L;
    private static final int UNSET_LIGHTING = LightUtils.toLight((int)0, (int)15, (int)0, (int)0) | Integer.MIN_VALUE;
    private static final int DEFAULT_LIGHTING = LightUtils.toLight((int)12, (int)2, (int)2, (int)2);
    private EntityData ed;
    private JobState lowWorkers;
    private BackgroundRetrieverState retriever;
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private WorldViewState worldState;
    private WorldListener worldListener = new WorldListener();
    private Set<Vec3i> lightingChanges = new HashSet<Vec3i>();
    private TimeState timeSource;
    private ObjectRootNode objectRoot;
    private int modelGridRadius = 1;
    private VersionedHolder<ComponentFilter<SpawnPosition>> positionFilter = new VersionedHolder();
    private int lobGridRadius = 1;
    private VersionedHolder<ComponentFilter<SpawnPosition>> lobPositionFilter = new VersionedHolder();
    private Map<EntityId, ModelView> viewIndex = new HashMap<EntityId, ModelView>();
    private DynArray<ModelView> viewArray = new DynArray(ModelView.class);
    private DynArray<ModelListener> modelListeners = new DynArray(ModelListener.class);
    private ListMultimap<EntityId, Consumer<Model>> watchers = MultimapBuilder.hashKeys().arrayListValues().build();
    private DynArray<Runnable> requests = new DynArray(Runnable.class);
    private ModelContainer models;
    private LargeModelContainer largeModels;
    private MobContainer mobs;
    private ShapeFactory<MBlockShape> shapeFactory;
    private SpatialFactory spatialFactory;
    private TypeBasedModelFactory modelFactory;
    private ModelCounts counts;

    public ModelViewState() {
        this.setEnabled(MythrunaConfig.getInstance().getStartupSetting("ModelViewState.enabled", true));
    }

    public TemporaryView createTemporaryView(final EntityId entityId, ShapeInfo shape) {
        log.info("createTemporaryView(" + entityId + ", " + shape + ")");
        final ModelView view = this.getView(entityId, true);
        view.acquire();
        view.update(shape);
        TemporaryView result = new TemporaryView(){

            @Override
            public void setWorldPosition(Vec3d world, Quatd rot) {
                view.setWorldPosition(world, rot);
            }

            @Override
            public void release() {
                ModelViewState.this.releaseView(entityId);
            }
        };
        return result;
    }

    public Model getModel(EntityId entityId) {
        ModelView view = this.viewIndex.get(entityId);
        if (view == null) {
            return null;
        }
        return view.model;
    }

    public Node getObjectRoot() {
        return this.objectRoot;
    }

    public VersionedReference<ComponentFilter<SpawnPosition>> createPositionFilterRef() {
        return this.positionFilter.createReference();
    }

    public void createSpatial(EntityId entityId, Consumer<Spatial> callback) {
        SpatialRequest request = new SpatialRequest(entityId, callback);
        this.retriever.getComponent(entityId, ShapeInfo.class, request);
    }

    public ModelCounts getModelCounts() {
        return this.counts;
    }

    public void addModelWatch(EntityId entityId, Consumer<Model> callback) {
        this.watchers.put((Object)entityId, callback);
        ModelView view = this.viewIndex.get(entityId);
        if (view != null && view.model != null) {
            callback.accept(view.model);
        }
        this.counts.updateCount("Watchers", this.watchers.size());
    }

    public void removeModelWatch(EntityId entityId, Consumer<Model> callback) {
        this.watchers.remove((Object)entityId, callback);
        this.counts.updateCount("Watchers", this.watchers.size());
    }

    public void addModelListener(ModelListener l) {
        this.modelListeners.add((Object)l);
    }

    public void removeModelListener(ModelListener l) {
        this.modelListeners.remove((Object)l);
    }

    public Vec3d getModelPosition(EntityId entityId) {
        ModelView model = this.viewIndex.get(entityId);
        return model == null ? null : model.worldLoc;
    }

    public Quatd getModelRotation(EntityId entityId) {
        ModelView model = this.viewIndex.get(entityId);
        return model == null ? null : model.worldRot;
    }

    public PickedObject pickObject(EntityId skip, Vec3d dir, double limit) {
        return this.pickObject(skip, this.centerWorld.toVec3d(), limit);
    }

    public PickedObject pickObject(EntityId skip, Vec3d world, Vec3d dir, double limit) {
        if (log.isDebugEnabled()) {
            log.debug("pickObject(" + skip + ", " + world + ", " + dir + ", " + limit + ")");
            log.debug("centerCell:" + this.centerCell + "  centerWorld:" + this.centerWorld);
        }
        Vec3d start = world.subtract(this.centerWorld.toVec3d());
        if (log.isDebugEnabled()) {
            log.debug("start:" + start);
        }
        Ray ray = new Ray(start.toVector3f(), dir.toVector3f());
        ray.setLimit((float)limit);
        CollisionResults crs = new CollisionResults();
        int count = this.objectRoot.pick((Collidable)ray, crs);
        for (CollisionResult cr : crs) {
            EntityId entityId;
            if (log.isDebugEnabled()) {
                log.debug("pickObject() cr:" + cr);
            }
            Spatial picked = SpatialUtils.findOidSpatial((Spatial)cr.getGeometry());
            if (log.isDebugEnabled()) {
                log.debug("pickObject()  picked:" + picked);
            }
            if (picked == null) continue;
            Long oid = (Long)picked.getUserData("oid");
            if (cr.getGeometry() != picked) {
                cr.getGeometry().setUserData("oid", (Object)oid);
            }
            if (Objects.equals(skip, entityId = new EntityId(oid.longValue()))) continue;
            Vector3f cp = cr.getContactPoint();
            if (log.isDebugEnabled()) {
                log.debug("pickObject() cp:" + cp + "  id:" + entityId);
            }
            Vec3d pos = new Vec3d(cp).add(this.centerWorld);
            Vec3d normal = new Vec3d(cr.getContactNormal());
            double dist = cr.getDistance();
            return new PickedObject(entityId, pos, normal, dist);
        }
        return null;
    }

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.retriever = (BackgroundRetrieverState)this.getState(BackgroundRetrieverState.class);
        this.timeSource = (TimeState)this.getState(TimeState.class);
        this.objectRoot = new ObjectRootNode(this, "objectRoot");
        this.worldState = (WorldViewState)this.getState(WorldViewState.class, true);
        this.worldState.addCellChangeListener(this.worldListener);
        this.lowWorkers = (JobState)this.getState("backgroundWorkers", JobState.class, true);
        this.counts = new ModelCounts();
        this.counts.createView("Mobs");
        this.counts.createView("Models");
        this.counts.createView("Lobs");
        this.counts.createView("Spatials");
        this.counts.createView("Watchers");
        this.counts.createView("Reqs");
        this.shapeFactory = ((GameSessionState)this.getState(GameSessionState.class)).getShapeFactory();
        this.spatialFactory = new SpatialFactory(((GameSessionState)this.getState(GameSessionState.class)).getModelGeometryFactory(), ((GameSessionState)this.getState(GameSessionState.class)).getCarveIncludes());
        this.modelFactory = new TypeBasedModelFactory();
        JobState workers = (JobState)this.getState("priorityWorkers", JobState.class, true);
        this.modelFactory.setDefaultFactory(new DefaultModelFactory(this.shapeFactory, this.spatialFactory, workers));
        GameSession session = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        this.modelFactory.registerFactory("rig", new RigModelFactory(this.shapeFactory, app.getAssetManager(), ((AvatarState)this.getState(AvatarState.class)).createAvatarIdReference(), id -> session.getCellArray(id), workers));
        DestructibleSessionClientService destructibles = ((ConnectionState)this.getState(ConnectionState.class)).getService(DestructibleSessionClientService.class);
        this.modelFactory.registerFactory("fax", new FaxModelFactory(this.shapeFactory, destructibles, ((GameSessionState)this.getState(GameSessionState.class)).getModelGeometryFactory(), ((GameSessionState)this.getState(GameSessionState.class)).getCarveIncludes(), workers, this.counts));
        this.modelFactory.registerFactory("j3o", new J3oModelFactory(app.getAssetManager(), workers));
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.models = new ModelContainer(this.ed);
        this.largeModels = new LargeModelContainer(this.ed);
        this.mobs = new MobContainer(this.ed);
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
    }

    protected void cleanup(Application app) {
        this.worldState.removeCellChangeListener(this.worldListener);
        log.info("viewArray size:" + this.viewArray.size());
        log.info("viewIndex size:" + this.viewIndex.size());
        for (ModelView view : this.viewIndex.values()) {
            if (view.useCount > 0) continue;
            log.warn("Lingering view:" + view + "  useCount:" + view.useCount);
        }
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.objectRoot);
        this.models.start();
        this.mobs.start();
        this.largeModels.start();
        this.counts.initialize((DebugHudState)this.getState(DebugHudState.class));
    }

    protected void onDisable() {
        this.objectRoot.removeFromParent();
        this.models.stop();
        this.mobs.stop();
        this.largeModels.stop();
        this.counts.terminate();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.mobs.update();
        this.models.update();
        this.largeModels.update();
        long time = this.timeSource.getTime();
        for (Mob mob : this.mobs.getArray()) {
            mob.update(time);
        }
        for (ModelView modelView : (ModelView[])this.viewArray.getArray()) {
            modelView.update();
        }
        if (!this.lightingChanges.isEmpty()) {
            for (ModelView modelView : (ModelView[])this.viewArray.getArray()) {
                modelView.updateLighting(this.lightingChanges);
            }
            this.lightingChanges.clear();
        }
        for (Runnable runnable : (Runnable[])this.requests.getArray()) {
            runnable.run();
        }
        this.counts.updateCount("Mobs", this.mobs.size());
        this.counts.updateCount("Models", this.models.size());
        this.counts.updateCount("Lobs", this.largeModels.size());
        this.counts.updateCount("Spatials", this.viewArray.size());
        this.counts.updateCount("Reqs", this.requests.size());
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        if (log.isTraceEnabled()) {
            log.trace("updateViewPosition(" + center + ")");
        }
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        this.resetRelativeCoordinates();
        if (this.models.setCenter(center, forceUpdate)) {
            this.positionFilter.updateObject((Object)this.models.getPositionFilter());
            if (log.isTraceEnabled()) {
                log.trace("model filter changed:" + this.models.getPositionFilter());
            }
        }
        if (this.largeModels.setCenter(center, forceUpdate) && log.isTraceEnabled()) {
            log.trace("large model filter changed:" + this.largeModels.getPositionFilter());
        }
    }

    protected void resetRelativeCoordinates() {
        for (ModelView m : (ModelView[])this.viewArray.getArray()) {
            m.updateRelativePosition();
        }
    }

    protected ModelView getView(EntityId entityId, boolean create) {
        if (log.isTraceEnabled()) {
            log.trace("getView(" + entityId + ")");
        }
        ModelView view = this.viewIndex.get(entityId);
        if (create && view == null) {
            view = new ModelView(entityId);
            this.viewIndex.put(entityId, view);
            this.viewArray.add((Object)view);
        }
        return view;
    }

    protected ModelView acquireView(EntityId entityId, boolean create) {
        ModelView view = this.getView(entityId, create);
        if (view != null) {
            view.acquire();
        }
        return view;
    }

    protected ModelView releaseView(EntityId entityId) {
        ModelView view;
        if (log.isTraceEnabled()) {
            log.trace("releaseView(" + entityId + ")");
        }
        if ((view = this.viewIndex.get(entityId)) == null) {
            log.warn("Releasing model that has not been acquired:" + entityId);
        } else if (view.release()) {
            this.viewIndex.remove(entityId);
            this.viewArray.remove((Object)view);
        }
        return view;
    }

    protected void fireModelCreated(Model model) {
        for (ModelListener l : (ModelListener[])this.modelListeners.getArray()) {
            l.modelCreated(model);
        }
        for (Consumer callback : this.watchers.get((Object)model.getEntityId())) {
            callback.accept(model);
        }
    }

    protected void fireModelReleased(Model model) {
        for (ModelListener l : (ModelListener[])this.modelListeners.getArray()) {
            l.modelReleased(model);
        }
        for (Consumer callback : this.watchers.get((Object)model.getEntityId())) {
            callback.accept(null);
        }
    }

    protected void lightingChanged(Vec3i world, CellEdit[] changes) {
        for (CellEdit edit : changes) {
            this.lightingChanges.add(world.add(edit.getCellLocation()));
        }
    }

    private class WorldListener
    implements CellChangeListener {
        private WorldListener() {
        }

        public void cellChanged(CellChangeEvent event) {
            CellEdit[] light = event.getLightChanges();
            if (light != null) {
                ModelViewState.this.getApplication().enqueue(() -> ModelViewState.this.lightingChanged(event.getLeafWorld(), light));
            }
        }
    }

    private final class ModelView {
        private EntityId entityId;
        private int useCount;
        private SpawnPosition pos;
        private ShapeInfo shapeInfo;
        private Vec3d worldLoc;
        private Quatd worldRot;
        private Supplier<Boolean> visCheck;
        private int lighting = UNSET_LIGHTING;
        private Vec3i worldCenterCell;
        private boolean visible;
        private boolean dynamic;
        private EntityId parentId;
        private ModelView parent;
        private DynArray<ModelView> children;
        private LightingUpdater lightingUpdater = new LightingUpdater(this);
        private ShapeName shapeName;
        private Model model;
        private VersionedReference<Spatial> spatialRef;
        private Spatial lastSpatial;

        public ModelView(EntityId entityId) {
            this.entityId = entityId;
        }

        public void setDynamic(boolean dynamic) {
            if (this.dynamic == dynamic) {
                return;
            }
            this.dynamic = dynamic;
            if (!dynamic) {
                this.update(this.pos);
            }
        }

        public void setParentId(EntityId parentId) {
            if (Objects.equals(this.parentId, parentId)) {
                return;
            }
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            this.parentId = parentId;
            if (parentId == null) {
                this.parent = null;
            }
            if (parentId != null) {
                this.parent = ModelViewState.this.getView(parentId, true);
                this.parent.addChild(this);
            }
            this.updateRelativePosition();
        }

        public EntityId getParentId() {
            return this.parentId;
        }

        public Spatial getSpatial() {
            return this.spatialRef == null ? null : (Spatial)this.spatialRef.get();
        }

        public void setLighting(int lighting) {
            if (this.lighting == lighting) {
                return;
            }
            this.lighting = lighting;
            if (this.children != null) {
                for (ModelView child : (ModelView[])this.children.getArray()) {
                    child.setLighting(lighting);
                }
            }
            if (this.model != null) {
                this.model.setLighting(lighting);
            }
        }

        public void updateLighting(Set<Vec3i> changes) {
            if (changes.contains(this.worldCenterCell)) {
                if (log.isTraceEnabled()) {
                    log.trace("updateLighting for:" + this.entityId);
                }
                this.lightingUpdater.update(this.worldCenterCell, true);
            }
        }

        protected void addChild(ModelView child) {
            if (this.children == null) {
                this.children = new DynArray(ModelView.class);
            }
            this.children.add((Object)child);
            child.setLighting(this.lighting);
            if (child.getSpatial() != null && this.model != null) {
                this.model.attachChild(child.getSpatial());
            }
        }

        public void removeChild(ModelView child) {
            if (this.children == null) {
                throw new IllegalArgumentException("View:" + this + " does not have children trying to remove:" + child);
            }
            if (!this.children.remove((Object)child)) {
                throw new IllegalArgumentException("View:" + this + " has no child:" + child);
            }
            if (child.model != null) {
                child.model.removeFromParent();
            }
        }

        public void setWorldPosition(Vec3d loc, Quatd rot) {
            this.worldLoc = loc;
            this.worldRot = rot;
            this.updateRelativePosition();
            this.updateLighting(false);
        }

        protected void setVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            if (this.model != null) {
                this.model.setVisible(visible);
            }
        }

        public void update() {
            this.setVisible(this.visCheck == null || this.visCheck.get() != false);
            if (this.spatialRef != null && this.spatialRef.update()) {
                this.updateSpatial((Spatial)this.spatialRef.get());
            }
        }

        protected void updateSpatial(Spatial spatial) {
            if (this.lastSpatial != null) {
                this.lastSpatial.removeFromParent();
            }
            this.lastSpatial = spatial;
            if (spatial == null) {
                return;
            }
            this.model.setVisible(this.visible);
            this.updateRelativePosition();
            if (this.parent != null) {
                this.model.setLighting(this.lighting);
                if (this.parent.model != null) {
                    this.parent.model.attachChild(spatial);
                }
            } else {
                ModelViewState.this.objectRoot.attachChild(spatial);
                if (this.lighting != UNSET_LIGHTING) {
                    this.model.setLighting(this.lighting);
                }
                this.updateLighting(true);
            }
            if (this.children != null) {
                for (ModelView child : (ModelView[])this.children.getArray()) {
                    if (child.getSpatial() == null) continue;
                    this.model.attachChild(child.getSpatial());
                }
            }
        }

        protected void update(SpawnPosition pos) {
            this.pos = pos;
            if (!this.dynamic) {
                this.setWorldPosition(pos.getLocation(), pos.getOrientation());
            }
        }

        protected void update(ShapeInfo shapeInfo) {
            if (Objects.equals(this.shapeInfo, shapeInfo)) {
                return;
            }
            this.shapeInfo = shapeInfo;
            ModelViewState.this.retriever.getString(shapeInfo.getShapeId(), this::loadShape);
        }

        protected void loadShape(String name) {
            String newName;
            log.info(this.entityId + ".loadShape(" + name + ")");
            ShapeName newShapeName = ShapeName.parse((String)name);
            String oldName = this.shapeName == null ? null : this.shapeName.getFullName();
            String string = newName = newShapeName == null ? null : newShapeName.getFullName();
            if (Objects.equals(oldName, newName)) {
                if (this.model != null && !Objects.equals(this.shapeName, newShapeName)) {
                    this.model.updateAddOns(newShapeName);
                }
                this.shapeName = newShapeName;
                return;
            }
            this.shapeName = newShapeName;
            if (this.model != null) {
                this.model.release();
                ModelViewState.this.fireModelReleased(this.model);
            }
            this.model = ModelViewState.this.modelFactory.createModel(this.entityId, this.shapeName, this.shapeInfo);
            ModelViewState.this.fireModelCreated(this.model);
            this.spatialRef = this.model.createSpatialRef();
            if (this.spatialRef.get() != null) {
                this.updateSpatial((Spatial)this.spatialRef.get());
            }
        }

        public void acquire() {
            ++this.useCount;
        }

        public boolean release() {
            --this.useCount;
            if (this.useCount <= 0) {
                if (this.model != null) {
                    this.model.release();
                    ModelViewState.this.fireModelReleased(this.model);
                    this.updateSpatial(null);
                }
                if (this.children != null) {
                    for (ModelView child : (ModelView[])this.children.getArray()) {
                        if (!Objects.equals(this.entityId, child.getParentId())) continue;
                        child.setParentId(null);
                    }
                }
                if (this.parent != null && this.parent.useCount == 0) {
                    log.warn("View:" + this + " parent:" + this.parent + " is now an orphan.");
                }
                return true;
            }
            return false;
        }

        public void updateRelativePosition() {
            if (this.worldLoc == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            Vec3d loc = this.worldLoc;
            if (this.parent == null) {
                loc = loc.subtract(ModelViewState.this.centerWorld.toVec3d());
            }
            this.model.updateRelativePosition(loc.toVector3f(), this.worldRot.toQuaternion());
        }

        protected void updateLighting(boolean force) {
            if (this.worldLoc == null) {
                return;
            }
            if (this.parent != null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            Vec3d offset = this.model.getCenterOffset();
            Vec3d pos = this.worldLoc.add(offset);
            Vec3i cell = pos.floor();
            if (force || !Objects.equals(this.worldCenterCell, cell)) {
                if (this.worldCenterCell == null) {
                    this.worldCenterCell = cell.clone();
                } else {
                    this.worldCenterCell.set(cell);
                }
                this.lightingUpdater.update(this.worldCenterCell, false);
            }
        }

        public String toString() {
            return "ModelView[" + this.entityId + ", children:" + this.children + "]";
        }
    }

    private class ObjectRootNode
    extends Node {
        public ObjectRootNode(ModelViewState modelViewState, String name) {
            super(name);
        }

        public int collideWith(Collidable other, CollisionResults results) {
            return 0;
        }

        public int pick(Collidable other, CollisionResults results) {
            return super.collideWith(other, results);
        }
    }

    private class SpatialRequest
    implements Runnable,
    Consumer<ShapeInfo> {
        private EntityId entityId;
        private ShapeInfo shapeInfo;
        private Model model;
        private Consumer<Spatial> callback;

        public SpatialRequest(EntityId entityId, Consumer<Spatial> callback) {
            this.entityId = entityId;
            this.callback = callback;
        }

        @Override
        public void accept(ShapeInfo shapeInfo) {
            log.info(this + ".accept(" + shapeInfo + ")");
            this.shapeInfo = shapeInfo;
            ModelViewState.this.retriever.getString(shapeInfo.getShapeId(), this::loadShape);
        }

        protected void loadShape(String name) {
            log.info(this + ".loadShape(" + name + ")");
            ShapeName shapeName = ShapeName.parse((String)name);
            this.model = ModelViewState.this.modelFactory.createModel(this.entityId, shapeName, this.shapeInfo);
            this.model.setLighting(DEFAULT_LIGHTING);
            if (this.model.getSpatial() != null) {
                this.callback.accept(this.model.getSpatial());
            } else {
                ModelViewState.this.requests.add((Object)this);
            }
        }

        @Override
        public void run() {
            log.info(this + "-> run() spatial:" + this.model.getSpatial());
            if (this.model.getSpatial() != null) {
                this.callback.accept(this.model.getSpatial());
                ModelViewState.this.requests.remove((Object)this);
            }
        }

        public String toString() {
            return "SpatialRequest[" + this.entityId + "]";
        }
    }

    private class ModelContainer
    extends SpatialEntityContainer<ModelView, SpawnPosition> {
        public ModelContainer(EntityData ed) {
            super((GridComponentIndex)new SpawnPositionIndex(GameConstants.PHYSICS_GRID, ModelViewState.this.modelGridRadius), ed, new Class[]{SpawnPosition.class, ShapeInfo.class});
        }

        public ModelView[] getArray() {
            return (ModelView[])super.getArray();
        }

        protected ModelView addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            }
            ModelView view = ModelViewState.this.acquireView(e.getId(), true);
            this.updateObject(view, e);
            view.visCheck = new StaticVisibilitySupplier(view, ModelViewState.this.timeSource.getTime() + 100000000L);
            return view;
        }

        protected void updateObject(ModelView object, Entity e) {
            object.update((SpawnPosition)e.get(SpawnPosition.class));
            object.update((ShapeInfo)e.get(ShapeInfo.class));
        }

        protected void removeObject(ModelView object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove model for:" + e.getId());
            }
            ModelViewState.this.releaseView(e.getId());
        }
    }

    private class LargeModelContainer
    extends SpatialEntityContainer<ModelView, LargeGridCell> {
        public LargeModelContainer(EntityData ed) {
            super((GridComponentIndex)new LargeGridCellIndex(GameConstants.LARGE_OBJECT_GRID, ModelViewState.this.modelGridRadius), ed, new Class[]{LargeGridCell.class, SpawnPosition.class, ShapeInfo.class, LargeObject.class});
        }

        public ModelView[] getArray() {
            return (ModelView[])super.getArray();
        }

        protected ModelView addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add large model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            }
            ModelView view = ModelViewState.this.acquireView(e.getId(), true);
            this.updateObject(view, e);
            view.visCheck = new StaticVisibilitySupplier(view, ModelViewState.this.timeSource.getTime() + 100000000L);
            return view;
        }

        protected void updateObject(ModelView object, Entity e) {
            object.update((SpawnPosition)e.get(SpawnPosition.class));
            object.update((ShapeInfo)e.get(ShapeInfo.class));
        }

        protected void removeObject(ModelView object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove large model for:" + e.getId());
            }
            ModelViewState.this.releaseView(e.getId());
        }
    }

    private class MobContainer
    extends EntityContainer<Mob> {
        public MobContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, ShapeInfo.class});
        }

        public Mob[] getArray() {
            return (Mob[])super.getArray();
        }

        protected Mob addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add mob for:" + e.getId());
            }
            Mob object = new Mob(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Mob object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((BodyPosition)e.get(BodyPosition.class));
        }

        protected void removeObject(Mob object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove mob for:" + e.getId());
            }
            object.release();
        }
    }

    private class Mob
    implements Supplier<Boolean> {
        private Entity entity;
        private ModelView view;
        private BodyPosition pos;
        private TransitionBuffer<? extends ChildPositionTransition3d> buffer;
        private EntityId lastParent;
        private boolean visible;

        public Mob(Entity entity) {
            this.entity = entity;
            this.view = ModelViewState.this.acquireView(entity.getId(), true);
            this.view.visCheck = this;
        }

        @Override
        public Boolean get() {
            return this.visible;
        }

        public void setShape(ShapeInfo shapeInfo) {
            this.view.update(shapeInfo);
        }

        public void setPosition(BodyPosition pos) {
            if (this.pos == pos) {
                return;
            }
            pos.initialize(this.entity.getId(), 12);
            this.buffer = pos.getBuffer();
        }

        public void update(long time) {
            if (this.buffer == null) {
                throw new IllegalStateException("T001127: Transition buffer is null, local pos:" + this.pos + " entity pos:" + this.entity.get(BodyPosition.class));
            }
            ChildPositionTransition3d trans = (ChildPositionTransition3d)this.buffer.getTransition(time);
            if (trans != null) {
                Vec3d pos = trans.getPosition(time, true);
                this.view.setParentId(trans.getParentId(time, true));
                EntityId parentId = trans.getParentId(time, true);
                if (!Objects.equals(parentId, this.lastParent)) {
                    if (parentId == null) {
                        // empty if block
                    }
                    this.lastParent = parentId;
                }
                Quatd rot = trans.getRotation(time, true);
                this.view.setWorldPosition(pos, rot);
                this.visible = trans.getVisibility(time);
            }
        }

        public void release() {
            this.view.visCheck = null;
            this.view.setDynamic(false);
            ModelViewState.this.releaseView(this.entity.getId());
        }
    }

    private class LightingUpdater
    implements Job {
        private ModelView view;
        private Vec3i worldCell = new Vec3i();
        private volatile int light;
        private volatile boolean queued;

        public LightingUpdater(ModelView view) {
            this.view = view;
        }

        public void update(Vec3i worldCell, boolean force) {
            if (!force && this.worldCell.equals((Object)worldCell)) {
                return;
            }
            this.worldCell.set(worldCell);
            Integer retrieved = ModelViewState.this.worldState.getWorldLightIfPresent(worldCell.x, worldCell.y, worldCell.z);
            if (retrieved != null) {
                this.view.setLighting(retrieved);
                return;
            }
            if (!this.queued) {
                this.queued = true;
                ModelViewState.this.lowWorkers.execute((Job)this, -1);
            }
        }

        public void runOnWorker() {
            this.queued = false;
            if (log.isTraceEnabled()) {
                log.trace("query lighting for:" + this.view.entityId + " at:" + this.worldCell);
            }
            this.light = ModelViewState.this.worldState.getWorldLight(this.worldCell.x, this.worldCell.y, this.worldCell.z);
        }

        public double runOnUpdate() {
            if (log.isTraceEnabled()) {
                log.trace("setting lighting for:" + this.view.entityId + " to:" + this.light);
            }
            this.view.setLighting(this.light);
            return 0.01;
        }
    }

    private class StaticVisibilitySupplier
    implements Supplier<Boolean> {
        private ModelView view;
        private long timeout;

        public StaticVisibilitySupplier(ModelView view, long timeout) {
            this.view = view;
            this.timeout = timeout;
        }

        @Override
        public Boolean get() {
            if (ModelViewState.this.timeSource.getTime() > this.timeout) {
                this.view.visCheck = null;
                return true;
            }
            return false;
        }
    }
}

