/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mythruna.character.BodyConfig;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyConfigIndex {
    static Logger log = LoggerFactory.getLogger(BodyConfigIndex.class);
    public static final String BODY_TYPE_INDEX_CSV = "races/body-type-index.csv";
    private ListMultimap<String, BodyConfig> index = MultimapBuilder.hashKeys().arrayListValues().build();

    public BodyConfigIndex(List<BodyConfig> configs) {
        for (BodyConfig config : configs) {
            this.index.put((Object)config.getRaceId(), (Object)config);
        }
    }

    public BodyConfig find(String raceId, String model) {
        if (raceId != null) {
            return this.find(this.getBodyConfigs(raceId), model);
        }
        return this.find(this.index.values(), model);
    }

    protected BodyConfig find(Collection<BodyConfig> values, String model) {
        for (BodyConfig config : values) {
            if (model != null && !model.equals(config.getModel())) continue;
            return config;
        }
        return null;
    }

    public BodyConfig getFirst(String raceId) {
        List<BodyConfig> configs = this.getBodyConfigs(raceId);
        if (configs.isEmpty()) {
            return null;
        }
        return configs.get(0);
    }

    public List<BodyConfig> getBodyConfigs(String raceId) {
        return this.index.get((Object)raceId);
    }

    public static BodyConfigIndex create(Function<String, String> textFunc) {
        String text = textFunc.apply(BODY_TYPE_INDEX_CSV);
        BodyConfigIndex index = BodyConfigIndex.create(text);
        return index;
    }

    public static BodyConfigIndex create(String text) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<BodyConfig> configs = MapUtils.toObjects(records, BodyConfig.class);
        return new BodyConfigIndex(configs);
    }
}

