/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMarker
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(MapMarker.class);
    private EntityId owner;
    private int typeId;
    private int size;
    @IndexedField
    private long tileId;

    private MapMarker() {
    }

    public MapMarker(EntityId owner, int typeId, int size, long tileId) {
        this.owner = owner;
        this.typeId = typeId;
        this.size = size;
        this.tileId = tileId;
    }

    public static MapMarker create(String type, int size, Vec3d pos, EntityData ed) {
        return MapMarker.create(null, type, size, pos, ed);
    }

    public static MapMarker create(EntityId owner, String type, int size, Vec3d pos, EntityData ed) {
        int id = ed.getStrings().getStringId(type, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(type, true);
        }
        TileId tile = TileId.fromWorld((Vec3d)pos);
        return new MapMarker(owner, id, size, tile.getId());
    }

    public MapMarker changeSize(int size) {
        return new MapMarker(this.owner, this.typeId, size, this.tileId);
    }

    public EntityId getOwner() {
        return this.owner;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public int getSize() {
        return this.size;
    }

    public long getTileId() {
        return this.tileId;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.typeId) : this.getTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("owner", (Object)this.owner).add("typeId", (Object)s).add("size", this.size).add("tileId", this.tileId).toString();
    }
}

