/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeName {
    static Logger log = LoggerFactory.getLogger(ShapeName.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("(?:0x(\\d+)_)?(.*?)(?:\\.(\\w+))?$");
    private String type;
    private String name;
    private int flags;
    private List<ShapeName> addOns;

    public ShapeName(String type, String name) {
        this(type, name, 0, new ShapeName[0]);
    }

    public ShapeName(String type, String name, int flags, ShapeName ... addOns) {
        this(type, name, flags, new ArrayList<ShapeName>(Arrays.asList(addOns)));
    }

    public ShapeName(String type, String name, int flags, List<ShapeName> addOns) {
        this.type = type;
        this.name = name;
        this.flags = flags;
        this.addOns = addOns;
    }

    public ShapeName clearAddOns() {
        return new ShapeName(this.type, this.name, this.flags, new ShapeName[0]);
    }

    public static ShapeName parse(String s) {
        if (s == null) {
            return null;
        }
        String[] parts = s.split(",");
        ArrayList<ShapeName> list = new ArrayList<ShapeName>();
        for (int i = 0; i < parts.length - 1; ++i) {
            list.add(ShapeName.parseName(parts[i]));
        }
        String last = parts[parts.length - 1];
        ShapeName result = ShapeName.parseName(last);
        result.addOns = list;
        return result;
    }

    private static ShapeName parseName(String s) {
        Matcher m = NAME_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad name format:" + s);
        }
        String flagString = m.group(1);
        int flags = 0;
        if (flagString != null) {
            flags = Integer.parseInt(flagString, 16);
        }
        String name = m.group(2);
        String type = m.group(3);
        return new ShapeName(type, name, flags, new ShapeName[0]);
    }

    public String toCompositeString() {
        StringBuilder sb = new StringBuilder();
        if (!this.addOns.isEmpty()) {
            for (ShapeName sub : this.addOns) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(sub.toCompositeString());
            }
            sb.append(",");
        }
        if (this.flags != 0) {
            sb.append("0x");
            sb.append(Integer.toHexString(this.flags));
            sb.append("_");
        } else {
            Matcher m = NAME_PATTERN.matcher(this.name);
            if (m.matches() && m.group(1) != null) {
                sb.append("0x0_");
            }
        }
        sb.append(this.name);
        if (this.type != null) {
            sb.append(".");
            sb.append(this.type);
        }
        return sb.toString();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name + "." + this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public List<ShapeName> getAddOns() {
        return this.addOns;
    }

    public boolean equalsBase(ShapeName other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ShapeName other = (ShapeName)o;
        if (this.flags != other.flags) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.addOns, other.addOns);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.addOns, this.flags);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).add("flags", this.flags).add("addOns", this.addOns).toString();
    }
}

