/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogParser {
    static Logger log = LoggerFactory.getLogger(LogParser.class);
    private Pattern logPattern = Pattern.compile("^[\\d:,]+ (.*?) (.+?) (\\w+?)\\s+\\[.*");
    private List<StringBuilder> errors = new ArrayList<StringBuilder>();

    public List<String> getErrors() {
        ArrayList<String> results = new ArrayList<String>();
        for (StringBuilder sb : this.errors) {
            results.add(sb.toString());
        }
        return results;
    }

    public void parse(File f) throws IOException {
        try (FileInputStream fIn = new FileInputStream(f);){
            InputStreamReader in = new InputStreamReader((InputStream)fIn, StandardCharsets.UTF_8);
            this.parse(new BufferedReader(in));
        }
    }

    public void parse(BufferedReader in) throws IOException {
        String line = null;
        StringBuilder lastSection = null;
        while ((line = in.readLine()) != null) {
            Matcher m = this.logPattern.matcher(line);
            if (m.matches()) {
                if ("ERROR".equals(m.group(3))) {
                    lastSection = new StringBuilder(line);
                    this.errors.add(lastSection);
                    continue;
                }
                lastSection = null;
                continue;
            }
            if (lastSection == null) continue;
            lastSection.append("\n" + line);
        }
        System.out.println("errors:" + this.errors);
    }
}

