/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import com.simsilica.thread.Job;
import com.simsilica.thread.WorkerPool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mythruna.client.MythrunaConfig;
import mythruna.client.net.ConnectionState;
import mythruna.net.AccountSession;
import mythruna.world.es.WorldAge;
import mythruna.world.es.WorldSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldPreloader
implements Job {
    static Logger log = LoggerFactory.getLogger(WorldPreloader.class);
    private ConnectionState connection;
    private AccountSession account;
    private EntityData ed;
    private World world;
    private Consumer<Thread> onStart;
    private Consumer<Exception> onDone;
    private int poolSize;
    private int leafRadius;
    private int tileRadius;
    private Exception error;
    private SpawnPosition playerPosition;
    private EntityId characterId;
    private EntityId worldEntity;
    private WorldAge worldAge;
    private WorldSeed worldSeed;
    private String worldName;
    private Map<String, Material> materials;
    private List<Object> loaded = Collections.synchronizedList(new ArrayList());

    public WorldPreloader(EntityId characterId, ConnectionState connection) {
        this.characterId = characterId;
        this.connection = connection;
        this.ed = connection.getEntityData();
        this.world = connection.getService(World.class);
        this.account = connection.getService(AccountSession.class);
        MythrunaConfig config = MythrunaConfig.getInstance();
        this.leafRadius = config.getStartupSettingInt("WorldPreloader.leafRadius", 2);
        this.tileRadius = config.getStartupSettingInt("WorldPreloader.tileRadius", 1);
        this.poolSize = config.getStartupSettingInt("WorldPreloader.poolSize", 16);
        log.info("Using leafRadius:" + this.leafRadius + "  tileRadius:" + this.tileRadius + "  poolSize:" + this.poolSize);
    }

    public SpawnPosition getPlayerStart() {
        return this.playerPosition;
    }

    public WorldAge getWorldAge() {
        return this.worldAge;
    }

    public WorldSeed getWorldSeed() {
        return this.worldSeed;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public EntityId getWorldEntity() {
        return this.worldEntity;
    }

    public Map<String, Material> getMaterials() {
        return this.materials;
    }

    public void release() {
        this.loaded.clear();
    }

    public WorldPreloader onStart(Consumer<Thread> onStart) {
        this.onStart = onStart;
        return this;
    }

    public WorldPreloader onDone(Consumer<Exception> onDone) {
        this.onDone = onDone;
        return this;
    }

    protected void resourceSetup() {
        long start = System.nanoTime();
        try {
            InputStream in = this.getClass().getResourceAsStream("/materials.mset");
            if (in == null) {
                throw new RuntimeException("Resource /materials.mset not found");
            }
            this.materials = MaterialRegistry.loadCompiledMaterials((AssetManager)this.connection.getApplication().getAssetManager(), (InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading /materials.mset", e);
        }
        finally {
            long end = System.nanoTime();
            log.info("Read materials.mset in " + (double)(end - start) / 1000000.0 + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnWorker() {
        if (this.onStart != null) {
            this.onStart.accept(Thread.currentThread());
        }
        try {
            this.account.enterWorld(this.characterId);
        }
        catch (Exception e) {
            log.error("Error entering world", (Throwable)e);
            this.error = e;
            return;
        }
        int components = 6;
        int yLeafSize = 1 + (this.leafRadius + 1) * 2;
        int xzLeafSize = 1 + this.leafRadius * 2;
        int tileSize = 1 + this.tileRadius * 2;
        int total = components + xzLeafSize * xzLeafSize * yLeafSize + tileSize * tileSize;
        ProgressTracker tracker = ProgressTrackers.openTracker((String)"Entering world...");
        try {
            tracker.setMax((double)total);
            this.preload(tracker);
        }
        finally {
            tracker.close(true);
        }
    }

    protected void preload(final ProgressTracker tracker) {
        int z;
        int x;
        this.resourceSetup();
        tracker.increment();
        this.worldEntity = this.account.getWorldEntity();
        if (this.worldEntity == null) {
            this.error = new RuntimeException("No world entity found");
            return;
        }
        tracker.increment();
        this.worldAge = (WorldAge)this.ed.getComponent(this.worldEntity, WorldAge.class);
        if (this.worldAge == null) {
            this.error = new RuntimeException("No worldAge found");
            return;
        }
        tracker.increment();
        this.worldSeed = (WorldSeed)this.ed.getComponent(this.worldEntity, WorldSeed.class);
        if (this.worldSeed == null) {
            this.error = new RuntimeException("No worldSeed found");
            return;
        }
        tracker.increment();
        Name name = (Name)this.ed.getComponent(this.worldEntity, Name.class);
        this.worldName = name.getName();
        tracker.increment();
        this.playerPosition = (SpawnPosition)this.ed.getComponent(this.characterId, SpawnPosition.class);
        tracker.increment();
        log.info("player location:" + this.playerPosition);
        if (this.playerPosition == null) {
            log.error("Player has no spawn position:" + this.characterId);
            this.error = new RuntimeException("Player has no spawn position");
            return;
        }
        WorkerPool loaders = new WorkerPool(this.poolSize);
        Vec3i center = this.playerPosition.getLocation().floor();
        HashSet<TileId> tiles = new HashSet<TileId>();
        int radius = this.leafRadius;
        int yRadius = radius + 1;
        HashSet<LeafId> leafs = new HashSet<LeafId>();
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                for (int y = -yRadius; y <= yRadius; ++y) {
                    Vec3i loc = center.add(x * 32, y * 32, z * 32);
                    if (loc.y < 0) continue;
                    LeafId leafId = LeafId.fromWorld((Vec3i)loc);
                    tiles.add(leafId.getColumnId().getTileId());
                    leafs.add(leafId);
                }
            }
        }
        for (x = -this.tileRadius; x <= this.tileRadius; ++x) {
            for (z = -this.tileRadius; z <= this.tileRadius; ++z) {
                TileId tileId = TileId.fromWorld((Vec3i)center.add(x * 1024, 0, z * 1024));
                tiles.add(tileId);
            }
        }
        for (final TileId tileId : tiles) {
            loaders.execute(new Job(){

                public void runOnWorker() {
                    log.info("Loading terrain image for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTerrainImage(tileId, TerrainImageType.Terrain, Resolution.High));
                    log.info("Loading fluid image for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTerrainImage(tileId, TerrainImageType.Fluid, Resolution.High));
                    log.info("Loading trees for:" + tileId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getTrees(tileId, null));
                    tracker.increment();
                }

                public double runOnUpdate() {
                    return 0.0;
                }
            });
        }
        for (final LeafId leafId : leafs) {
            loaders.execute(new Job(){

                public void runOnWorker() {
                    log.info("Loading leaf data for:" + leafId);
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getLeaf(leafId));
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getLight(leafId));
                    WorldPreloader.this.loaded.add(WorldPreloader.this.world.getFluid(leafId));
                    tracker.increment();
                }

                public double runOnUpdate() {
                    return 0.0;
                }
            });
        }
        while (loaders.getQueuedJobCount() + loaders.getActiveJobCount() > 0) {
            loaders.update(Double.POSITIVE_INFINITY);
            log.info("Waiting another second...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Interrupted sleeping", (Throwable)e);
                break;
            }
        }
        log.info("Preload workers done, shutting them down...");
        loaders.shutdownNow(true);
    }

    public double runOnUpdate() {
        if (this.onDone != null) {
            this.onDone.accept(this.error);
        }
        return 0.0;
    }
}

