/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */


def grass = RandomLocations.grass(); 

// Have to limit index-based strings to 50 characters.
//|         |         |         |         |         |   duration
// /Sounds/foley/cricket3.ogg                           16   
// /Sounds/foley/crickets1.ogg                          17
// /Sounds/foley/crickets2.ogg                          27
// /Sounds/foley/dove-low.ogg                           4.1
// /Sounds/foley/Mockingbird_Call_1-low.ogg             3.5
// /Sounds/foley/Mockingbird_Call_2-low.ogg             6.125
// /Sounds/foley/Mockingbird_Call_7-low.ogg             6.625
// /Sounds/foley/Mockingbird_Two_Calls_3-low.ogg        4.875
// /Sounds/foley/Owls_Loop_2-low.ogg                    10.563
// /Sounds/foley/Snowy_owl1.ogg                         1.811
// /Sounds/foley/Snowy_owl2.ogg                         5.294

// Old Mythruna effectively multiplied all sounds by 1.5 so to
// match, we will too.
def soundMultiplier = 1.5;

// Sounds are also 9x more likely to happen because we roll
// 9 times (at least).  I think that means that a sound with 
// probability of 0.1 is actually a probability of like 6.1.
// (probably of not happening 0.9 ^ 9 = .387)
// (.988 ^ 9 = 0.897 which is an effective probability of 0.1)
// So we will base our 0.1 probably on 0.012
def baseProbability = 0.012



//"Sounds/foley/Crickets,_Night,_Chirp,_Single_1-low.ogg", = crickets1.ogg
//        addFoley( foleys[0], 0.7f, 0.1f, 2, 10, new Vector3f( 20, 10, 20 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0.5f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0.25f, 1f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/crickets1.ogg") {
    duration = 16
    gain = 0.7 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.grass();
    minInterval = 2
    maxInterval = 10
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("5:00", 1.0)
        at("7:00", 0.0)
        at("18:00", 0.0)
        at("19:00", 0.25)
        at("20:00", 1.0)
    }
}

//"Sounds/foley/Crickets,_Night,_Chirp,_Single_2-low.ogg", = crickets2.ogg
//        addFoley( foleys[1], 0.7f, 0.1f, 2, 10, new Vector3f( 20, 10, 20 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0.5f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0.25f, 1f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/crickets2.ogg") {
    duration = 17
    gain = 0.7 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.grass();
    minInterval = 2
    maxInterval = 10
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("5:00", 1.0)
        at("7:00", 0.0)
        at("18:00", 0.0)
        at("19:00", 0.25)
        at("20:00", 1.0)
    }
}

//"Sounds/foley/Single_Cricket_Short-low.ogg",             = cricket3.ogg
//        addFoley( foleys[2], 0.4f, 0.1f, 2, 10, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0.5f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0.25f, 1f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/cricket3.ogg") {
    duration = 27
    gain = 0.4 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.grass();
    minInterval = 2
    maxInterval = 10
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("5:00", 1.0)
        at("7:00", 0.0)
        at("18:00", 0.0)
        at("19:00", 0.25)
        at("20:00", 1.0)
    }
}

//"Sounds/foley/Owls_Loop_2-low.ogg",
//        addFoley( foleys[3], 0.5f, 0.1f, 2, 10, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/Owls_Loop_2-low.ogg") {
    duration = 10.6
    gain = 0.5 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 10
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("3:00", 1.0)
        at("4:00", 0.0)
        at("20:00", 0.0)
        at("21:00", 1.0)
    }
}

//"Sounds/foley/Snowy_owl,_one_year_old,_crying-low.ogg",  = Snowy_owl1.ogg
//        addFoley( foleys[4], 0.7f, 0.1f, 2, 20, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/Snowy_owl1.ogg") {
    duration = 1.82
    gain = 0.7 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 20
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("3:00", 1.0)
        at("4:00", 0.0)
        at("20:00", 0.0)
        at("21:00", 1.0)
    }
}

//"Sounds/foley/Snowy_owl,_one_year_old,_crying_while_twittering_and_chattering-low.ogg", = Snowy_owl2.ogg
//        addFoley( foleys[5], 0.7f, 0.1f, 2, 20, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    1f, 1f, 1f, 1f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 1f, 1f, 1f
//                  } );
addSoundEncounter("/Sounds/foley/Snowy_owl2.ogg") {
    duration = 5.3
    gain = 0.7 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 20
    
    volume = scheduledDouble("24:00") {
        at("0:00", 1.0)
        at("3:00", 1.0)
        at("4:00", 0.0)
        at("20:00", 0.0)
        at("21:00", 1.0)
    }
}

// Dove
//"Sounds/foley/dove-low.ogg",
//        addFoley( foleys[6], 1f, 0.25f, 2, 10, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    0f, 0f, 0f, 0f, 0f, 0.5f,
//                    0.5f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    0f, 1f, 0.5f, 0f, 0f, 0f
//                  } );
addSoundEncounter("/Sounds/foley/dove-low.ogg") {
    duration = 4.1
    gain = 1.0 * soundMultiplier 
    probability = baseProbability * 2.5
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 10
    
    volume = scheduledDouble("24:00") {
        at("0:00", 0.0)
        at("4:00", 0.0)
        at("5:00", 0.5)
        at("6:00", 0.5)
        at("7:00", 0.0)
        at("18:00", 0.0)
        at("19:00", 1.0)
        at("20:00", 0.5)
        at("21:00", 0.0)
    }
}


// Daytime birds
//"Sounds/foley/Mockingbird_Call_1-low.ogg",
//        addFoley( foleys[7], 0.4f, 0.1f, 2, 20, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0f, 0f, 0f, 0f, 0f, 0f
//                  } );
addSoundEncounter("/Sounds/foley/Mockingbird_Call_1-low.ogg") {
    duration = 3.5
    gain = 0.4 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 20
    
    volume = scheduledDouble("24:00") {
        at("0:00", 0.0)
        at("5:00", 0.0)
        at("6:00", 1.0)
        at("17:00", 1.0)
        at("19:00", 0.0)
    }
}

//"Sounds/foley/Mockingbird_Call_2-low.ogg",
//        addFoley( foleys[8], 0.4f, 0.1f, 2, 20, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0f, 0f, 0f, 0f, 0f, 0f
//                  } );
addSoundEncounter("/Sounds/foley/Mockingbird_Call_2-low.ogg") {
    duration = 6.2
    gain = 0.4 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 20
    
    volume = scheduledDouble("24:00") {
        at("0:00", 0.0)
        at("5:00", 0.0)
        at("6:00", 1.0)
        at("17:00", 1.0)
        at("19:00", 0.0)
    }
}

//"Sounds/foley/Mockingbird_Call_7-low.ogg",
//        addFoley( foleys[9], 0.4f, 0.1f, 2, 20, new Vector3f( 40, 10, 40 ),
//                  new Float[] {
//                    0f, 0f, 0f, 0f, 0f, 0f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    1f, 1f, 1f, 1f, 1f, 1f,
//                    0f, 0f, 0f, 0f, 0f, 0f
//                  } );
addSoundEncounter("/Sounds/foley/Mockingbird_Call_7-low.ogg") {
    duration = 6.7
    gain = 0.4 * soundMultiplier 
    probability = baseProbability
    locations = RandomLocations.leaves();
    minInterval = 2
    maxInterval = 20
    
    volume = scheduledDouble("24:00") {
        at("0:00", 0.0)
        at("5:00", 0.0)
        at("6:00", 1.0)
        at("17:00", 1.0)
        at("19:00", 0.0)
    }
}



//
// Method signature and foley sound list from original mythruna
//    public void addFoley( String sound, float gain, float probability, float minTime, float maxTime,
//                          Vector3f range, Float... values )
//
//        String[] foleys = new String[] {
//                "Sounds/foley/Crickets,_Night,_Chirp,_Single_1-low.ogg", = crickets1.ogg
//                "Sounds/foley/Crickets,_Night,_Chirp,_Single_2-low.ogg", = crickets2.ogg
//                "Sounds/foley/Single_Cricket_Short-low.ogg",             = cricket3.ogg
//                "Sounds/foley/Owls_Loop_2-low.ogg",
//                "Sounds/foley/Snowy_owl,_one_year_old,_crying-low.ogg",  = Snowy_owl1.ogg
//                "Sounds/foley/Snowy_owl,_one_year_old,_crying_while_twittering_and_chattering-low.ogg", = Snowy_owl2.ogg
// 
//                "Sounds/foley/dove-low.ogg",
//                
//                "Sounds/foley/Mockingbird_Call_1-low.ogg",
//                "Sounds/foley/Mockingbird_Call_2-low.ogg",
//                "Sounds/foley/Mockingbird_Call_7-low.ogg",
//                
//                // Apparently never used?
//                "Sounds/foley/Mockingbird_Two_Calls_3-low.ogg"
//            };
//
