#import "Common/ShaderLib/GLSLCompat.glsllib"
uniform mat4 g_WorldViewProjectionMatrix;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec4 inTexCoord;

varying vec4 color;

#ifdef USE_TEXTURE
varying vec4 texCoord;
#endif

#ifdef POINT_SPRITE
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;
uniform float m_Quadratic;
const float SIZE_MULTIPLIER = 4.0;
attribute float inSize;
#endif

#ifdef HAS_CLIP
uniform vec4 m_Clip;
#endif

#ifdef HAS_FADE
uniform vec2 m_SunFade;
#endif

void main() {
    vec4 pos = vec4(inPosition, 1.0);

    gl_Position = g_WorldViewProjectionMatrix * pos;
    color = inColor;

    #ifdef USE_TEXTURE
        texCoord = inTexCoord;
    #endif

    #ifdef POINT_SPRITE
        vec4 worldPos = g_WorldMatrix * pos;
        vec3 relative = worldPos.xyz - g_CameraPosition.xyz;
        float d = length(relative); //distance(g_CameraPosition.xyz, worldPos.xyz);
        float size = (inSize * SIZE_MULTIPLIER * m_Quadratic) / d;
        
        //size = step(worldPos.y, 0.0) * size;
        // Clamp at the horizon... but try to fade a little on the way.
        // We shift by 'size' so that we can start fading before the horizon.
        float margin = max(size, 1.0);
        float horz = (worldPos.y - g_CameraPosition.y);
        
        #ifdef HAS_CLIP
            float clipDist = distance(worldPos.xyz, m_Clip.xyz);
            if( clipDist - m_Clip.w < margin ) {
                horz = clipDist - m_Clip.w; 
            }
            //if( clip < m_Clip.w ) {
            //    color = vec4(1.0, 0.0, 0.0, 1.0);
            //} else {
            //    color = vec4(0.0, 1.0, 0.0, 1.0);
            //}
        #endif
         
        if( horz < margin ) {
            size = size * max(0.0, horz/margin);
        }

        #ifdef HAS_FADE
            //float opacity = 1.0 - (max(m_SunFade.x, pos.x) - m_SunFade.x) / m_SunFade.y;
            float opacity = clamp(pos.x, m_SunFade.x, m_SunFade.y) - m_SunFade.x;
            opacity = opacity / max(0.001, m_SunFade.y - m_SunFade.x);
            opacity = 1.0 - opacity;
            //if( opacity < 1.0 ) {
            //    color = vec4(1.0, 0.0, 0.0, 1.0);
            //}
            size *= opacity;
        #endif  
        
        gl_PointSize = max(1.0, size);
        //gl_PointSize = max(0.1, size);

        //vec4 worldViewPos = g_WorldViewMatrix * pos;
        //gl_PointSize = (inSize * SIZE_MULTIPLIER * m_Quadratic)*100.0 / worldViewPos.z;

        color.a *= min(size, 1.0);                
    #endif
}
