/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.pc.PointType;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialFactories {
    static Logger log = LoggerFactory.getLogger(MaterialFactories.class);

    public static Function<TerrainImageType, Material> coloredTerrainMaterial(Application app, ColorRGBA groundColor, ColorRGBA waterColor) {
        return type -> {
            String matDef = "MatDefs/terrain/Terrain.j3md";
            ColorRGBA color = groundColor;
            if (type == TerrainImageType.Fluid) {
                color = waterColor;
            }
            Material mat = new Material(app.getAssetManager(), matDef);
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", ColorRGBA.White);
            if (color.a < 1.0f) {
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            }
            if (type != TerrainImageType.Fluid) {
                mat.setBoolean("CalculateNormals", true);
            }
            mat.setBoolean("SmoothLighting", true);
            return mat;
        };
    }

    public static Function<TerrainImageType, Material> coloredFarTerrainMaterial(Application app, ColorRGBA groundColor, ColorRGBA waterColor) {
        return type -> {
            ColorRGBA color = groundColor;
            if (type == TerrainImageType.Fluid) {
                color = waterColor;
            }
            Material mat = new Material(app.getAssetManager(), "MatDefs/terrain/Terrain.j3md");
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", color);
            if (type != TerrainImageType.Fluid) {
                mat.setBoolean("CalculateNormals", true);
            }
            mat.setBoolean("SmoothLighting", true);
            if (color.a < 1.0f) {
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            }
            return mat;
        };
    }

    public static Function<String, Material> treeBillboardMaterial(Application app) {
        return atlasName -> {
            Material mat = new Material(app.getAssetManager(), "MatDefs/tree/TreeBB.j3md");
            if (atlasName != null) {
                Texture treeAtlas = app.getAssetManager().loadTexture(atlasName);
                mat.setTexture("DiffuseMap", treeAtlas);
            }
            mat.setFloat("AlphaDiscardThreshold", 0.25f);
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
            mat.setColor("Ambient", new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            return mat;
        };
    }

    public static Function<PointType, Material> pointCloudMaterial(Application app) {
        return type -> {
            Material mat = new Material(app.getAssetManager(), "MatDefs/BlockPoints.j3md");
            Texture atlas = app.getAssetManager().loadTexture("Textures/palette1.png");
            mat.setTexture("ColorMap", atlas);
            mat.setFloat("ClipDistance", 8192.0f);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            return mat;
        };
    }
}

