/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.input;

import com.simsilica.lemur.input.Axis;
import com.simsilica.lemur.input.Button;
import java.util.Objects;

public class InputDevice {
    public static final InputDevice JOYSTICK1 = InputDevice.joystick(1);
    public static final InputDevice JOYSTICK2 = InputDevice.joystick(2);
    private String id;
    private String name;

    public InputDevice(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static InputDevice joystick(int id) {
        return new InputDevice("joystick" + id, "Joystick " + id);
    }

    public DeviceButton button(Button b) {
        return new DeviceButton(this, b);
    }

    public DeviceAxis axis(Axis a) {
        return new DeviceAxis(this, a);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        InputDevice other = (InputDevice)o;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "InputDevice[" + this.id + "]";
    }

    public static class DeviceAxis
    extends Axis {
        private InputDevice device;
        private Axis axis;

        public DeviceAxis(InputDevice device, Axis axis) {
            super(axis.getId(), axis.getName());
            this.device = device;
            this.axis = axis;
        }

        public InputDevice getDevice() {
            return this.device;
        }

        public Axis getAxis() {
            return this.axis;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.device, this.axis);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            DeviceAxis other = (DeviceAxis)o;
            if (!Objects.equals(other.axis, this.axis)) {
                return false;
            }
            return Objects.equals(other.device, this.device);
        }

        @Override
        public String toString() {
            return this.device + "->" + this.axis;
        }
    }

    public static class DeviceButton
    extends Button {
        private InputDevice device;
        private Button button;

        public DeviceButton(InputDevice device, Button button) {
            super(button.getId(), button.getName());
            this.device = device;
            this.button = button;
        }

        public InputDevice getDevice() {
            return this.device;
        }

        public Button getButton() {
            return this.button;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.device, this.button);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            DeviceButton other = (DeviceButton)o;
            if (!Objects.equals(other.button, this.button)) {
                return false;
            }
            return Objects.equals(other.device, this.device);
        }

        @Override
        public String toString() {
            return this.device + "->" + this.button;
        }
    }
}

