/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import mythruna.assembly.Joint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JointController<T> {
    static Logger log = LoggerFactory.getLogger(JointController.class);
    private Joint joint;
    private T target;
    private double mix;
    private Vec3d location = new Vec3d();
    private Quatd orientation = new Quatd();

    protected JointController(Joint joint, T target) {
        this.joint = joint;
        this.target = target;
        this.location.set(joint.getLocation());
        this.orientation.set(joint.getOrientation());
    }

    public Joint getJoint() {
        return this.joint;
    }

    public T getTarget() {
        return this.target;
    }

    protected abstract void apply(T var1, Vec3d var2, Quatd var3);

    public String getJointName() {
        return this.joint.getName();
    }

    public boolean matchesVerb(String verb) {
        return this.joint.matchesVerb(verb);
    }

    public void setMix(double mix) {
        if (mix < 0.0) {
            mix = 0.0;
        } else if (mix > 1.0) {
            mix = 1.0;
        }
        if (this.mix == mix) {
            return;
        }
        this.mix = mix;
        this.location.interpolateLocal(this.joint.getLocation(), this.joint.getTargetLocation(), mix);
        this.orientation.slerpLocal(this.joint.getOrientation(), this.joint.getTargetOrientation(), mix);
        this.orientation.normalizeLocal();
        this.apply(this.target, this.location, this.orientation);
    }

    public double getMix() {
        return this.mix;
    }

    protected MoreObjects.ToStringHelper appendToString(MoreObjects.ToStringHelper helper) {
        return helper.add("joint", (Object)this.joint).add("target", this.target).add("mix", this.mix);
    }

    public String toString() {
        return this.appendToString(MoreObjects.toStringHelper((String)this.getClass().getSimpleName())).toString();
    }
}

