/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.Morphology;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import mythruna.world.river.WaterBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterBodyFileTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(WaterBodyFileTileFunction.class);
    private List<WaterBody> waterBodies;

    public WaterBodyFileTileFunction(File file) {
        try {
            String json = Files.toString((File)file, (Charset)Charsets.UTF_8);
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            TypeToken<List<WaterBody>> collectionType = new TypeToken<List<WaterBody>>(this){};
            this.waterBodies = (List)gson.fromJson(json, collectionType.getType());
            Collections.sort(this.waterBodies, (b1, b2) -> {
                int result = Integer.compare(b2.getRadius(), b1.getRadius());
                if (result == 0) {
                    result = Integer.compare(b1.getCenter().y, b2.getCenter().y);
                }
                return result;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file:" + file, e);
        }
    }

    protected boolean intersects(Vec3i tileOrigin, WaterBody water) {
        Vec3i min = water.getMin();
        Vec3i max = water.getMax();
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public void accept(Tile tile) {
        MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morph == null) {
            morph = new MorphologyLayer(tile.getTileId(), new DataVersion(0L, -1L));
            tile.put(MorphologyLayer.class, (Object)morph);
        } else if (morph.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        Vec3i origin = tile.getTileId().getWorld(null);
        for (WaterBody water : this.waterBodies) {
            if (!this.intersects(origin, water)) continue;
            morph.addMorphology((Morphology)water);
        }
    }
}

