/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.simsilica.ethereal.DebugUtils;
import com.simsilica.ethereal.Statistics;
import com.simsilica.ethereal.SynchedTimeSource;
import com.simsilica.ethereal.net.ObjectStateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTimeSource
implements SynchedTimeSource {
    static Logger log = LoggerFactory.getLogger(RemoteTimeSource.class);
    private long lastTime = 0L;
    private volatile long drift = 0L;
    private volatile boolean uninitialized = true;
    private long offset = 0L;
    private long lastServerTime = 0L;
    private long windowMax = 100L;
    private long windowSize = 0L;
    private Statistics.Sequence syncTime;

    public RemoteTimeSource() {
        this(0L);
    }

    public RemoteTimeSource(long offset) {
        this.offset = offset;
        this.syncTime = Statistics.getSequence("syncTime", true);
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    protected void updateDrift(long serverTime) {
        this.syncTime.add(serverTime);
        this.lastServerTime = serverTime;
        long t = System.nanoTime();
        long delta = serverTime - t;
        long newDrift = (delta + this.drift * this.windowSize) / (this.windowSize + 1L);
        if (log.isDebugEnabled()) {
            log.debug("======== Time delta:" + DebugUtils.timeString(delta) + "  drift:" + DebugUtils.timeString(newDrift) + "  windowSize:" + this.windowSize);
            log.debug("=== oldDrift:" + this.drift + "  drift change:" + DebugUtils.timeString(newDrift - this.drift));
        }
        this.drift = newDrift;
        if (this.windowSize < this.windowMax) {
            ++this.windowSize;
        }
        this.uninitialized = false;
    }

    public void update(ObjectStateMessage msg) {
        long t = msg.getTime();
        if (t > this.lastServerTime) {
            this.updateDrift(t);
        }
    }

    @Override
    public long getTime() {
        if (this.uninitialized) {
            return 0L;
        }
        long raw = System.nanoTime();
        long t = raw + this.drift + this.offset;
        if (t > this.lastTime) {
            this.lastTime = t;
        } else if (log.isWarnEnabled()) {
            log.warn("Time didn't advance:" + (this.lastTime - t) + " nanos.  Current:" + t + "  Last:" + this.lastTime + "  Raw:" + raw + "  Drift:" + this.drift + "  Offset:" + this.offset);
        }
        return this.lastTime;
    }

    @Override
    public long getDrift() {
        return this.drift;
    }
}

