/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import mythruna.client.ui.assembly.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuatdEditor
extends Container
implements VersionedObject<Quatd> {
    static Logger log = LoggerFactory.getLogger(QuatdEditor.class);
    public static final String ELEMENT_ID = "quatdEditor";
    private VersionedHolder<Quatd> value = new VersionedHolder();
    private Spinner<Double> yawSpinner;
    private VersionedReference<Double> yawRef;
    private Spinner<Double> pitchSpinner;
    private VersionedReference<Double> pitchRef;
    private Spinner<Double> rollSpinner;
    private VersionedReference<Double> rollRef;

    public QuatdEditor(SequenceModel<Double> yawModel, SequenceModel<Double> pitchModel, SequenceModel<Double> rollModel, String format, float minSpinnerWidth) {
        super((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.None, FillMode.None), true, new ElementId(ELEMENT_ID).child("container"), null);
        ElementId labelId = new ElementId(ELEMENT_ID).child("label");
        this.addChild((Node)new Label("yaw:", labelId), new Object[0]);
        this.yawSpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(yawModel, format), new Object[0]);
        Vector3f pref = this.yawSpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.yawSpinner.setPreferredSize(pref);
        this.yawRef = this.yawSpinner.getModel().createReference();
        this.addChild((Node)new Label("pitch:", labelId), new Object[0]);
        this.pitchSpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(pitchModel, format), new Object[0]);
        pref = this.pitchSpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.pitchSpinner.setPreferredSize(pref);
        this.pitchRef = this.pitchSpinner.getModel().createReference();
        this.addChild((Node)new Label("roll:", labelId), new Object[0]);
        this.rollSpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(rollModel, format), new Object[0]);
        pref = this.rollSpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.rollSpinner.setPreferredSize(pref);
        this.rollRef = this.rollSpinner.getModel().createReference();
    }

    public void setObject(Quatd value) {
        if (this.value.getObject() != value) {
            this.value.setObject((Object)value);
            this.resetSpinners(value);
        }
    }

    public Quatd getObject() {
        return (Quatd)this.value.getObject();
    }

    public VersionedReference<Quatd> createReference() {
        return this.value.createReference();
    }

    public long getVersion() {
        return this.value.getVersion();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.value.getObject() == null) {
            return;
        }
        Quatd val = (Quatd)this.value.getObject();
        boolean changed = false;
        if (this.yawRef.update()) {
            changed = true;
        }
        if (this.pitchRef.update()) {
            changed = true;
        }
        if (this.rollRef.update()) {
            changed = true;
        }
        if (changed) {
            double[] angles = new double[]{Math.toRadians(-((Double)this.pitchRef.get()).doubleValue()), Math.toRadians((Double)this.yawRef.get()), Math.toRadians((Double)this.rollRef.get())};
            val.fromAngles(angles);
            this.value.incrementVersion();
        }
    }

    protected void resetSpinners(Quatd val) {
        double[] angles = val.toAngles(null);
        this.pitchSpinner.setValue((Object)Math.toDegrees(-angles[0]));
        this.yawSpinner.setValue((Object)Math.toDegrees(angles[1]));
        this.rollSpinner.setValue((Object)Math.toDegrees(angles[2]));
    }
}

