/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.Substance;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstanceType
implements Serializable {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(SubstanceType.class);
    private static final double EPSILON = 1.0E-6;
    private String name;
    private double hardness;
    private double toughness;
    private double density;
    private double friction;
    private Substance[] mix;

    public SubstanceType() {
    }

    public SubstanceType(String name, double hardness, double toughness, double density, double friction, Substance ... mix) {
        this.name = name;
        this.hardness = hardness;
        this.toughness = toughness;
        this.density = density;
        this.friction = friction;
        this.mix = mix == null || mix.length == 0 ? null : mix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHardness(double hardness) {
        this.hardness = hardness;
    }

    public double getHardness() {
        return this.hardness;
    }

    public void setToughness(double toughness) {
        this.toughness = toughness;
    }

    public double getToughness() {
        return this.toughness;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public double getDensity() {
        return this.density;
    }

    public void setFriction(double friction) {
        this.friction = friction;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setMix(Substance ... mix) {
        this.mix = mix;
    }

    public Substance[] getMix() {
        return this.mix;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hardness, this.toughness, this.density, this.friction, Arrays.hashCode(this.mix));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SubstanceType other = (SubstanceType)o;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (Math.abs(this.hardness - other.hardness) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.toughness - other.toughness) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.density - other.density) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.friction - other.friction) > 1.0E-6) {
            return false;
        }
        return Arrays.equals(this.mix, other.mix);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("hardness", this.hardness).add("toughness", this.toughness).add("density", this.density).add("friction", this.friction).add("mix", (Object)Arrays.toString(this.mix)).toString();
    }
}

