/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.es.EntityId;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import com.simsilica.mblock.CellArray;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.sim.GameSystemManager;
import java.util.Locale;
import mythruna.net.DestructibleSession;
import mythruna.net.DestructibleSessionListener;
import mythruna.sim.DestructibleListener;
import mythruna.sim.DestructibleObjectSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestructibleSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(DestructibleSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = DestructibleSession.class.getName();
    private GameSystemManager gameSystems;
    private RmiHostedService rmiService;
    private byte channel;

    public DestructibleSessionHostedService(GameSystemManager gameSystems, int channel) {
        this.gameSystems = gameSystems;
        this.channel = (byte)channel;
        this.setAutoHost(false);
    }

    protected DestructibleSessionImpl getSession(HostedConnection conn) {
        return (DestructibleSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("DestructibleSessionHostedService requires an RMI service.");
        }
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{PlayerEntityEvent.playerEntityJoining, PlayerEntityEvent.playerEntityLeft});
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{PlayerEntityEvent.playerEntityJoining, PlayerEntityEvent.playerEntityLeft});
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        DestructibleSessionImpl session = this.getSession(conn);
        if (session != null) {
            session.close();
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected void playerEntityJoining(PlayerEntityEvent event) {
        log.info("playerEntityJoining(" + event + ")");
        HostedConnection conn = event.getConnection();
        DestructibleSessionImpl session = new DestructibleSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share(this.channel, (Object)session, DestructibleSession.class);
        DestructibleSessionListener listener = (DestructibleSessionListener)rmi.getRemoteObject(DestructibleSessionListener.class);
        if (listener == null) {
            throw new RuntimeException("Unable to locate client callback for DestructibleSessionListener");
        }
        session.listener = listener;
        ((DestructibleObjectSystem)((Object)this.gameSystems.get(DestructibleObjectSystem.class, true))).addListener(session);
    }

    protected void playerEntityLeft(PlayerEntityEvent event) {
        log.info("playerEntityLeft(" + event + ")");
        this.stopHostingOnConnection(event.getConnection());
    }

    private class DestructibleSessionImpl
    implements DestructibleSession,
    DestructibleListener {
        private HostedConnection conn;
        private Locale locale;
        private DestructibleSessionListener listener;

        public DestructibleSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        public void close() {
            log.info("close():" + this);
        }

        @Override
        public void cellChanged(EntityId objectId, int x, int y, int z, int value) {
            this.listener.objectCellChanged(objectId, x, y, z, value);
        }

        @Override
        public byte[] getObjectCellBytes(EntityId objectId) {
            CellArray array = this.getObjectCellArray(objectId);
            return array == null ? null : CellArrayProtocol.toBytes((CellArray)array);
        }

        @Override
        public CellArray getObjectCellArray(EntityId objectId) {
            return ((DestructibleObjectSystem)((Object)DestructibleSessionHostedService.this.gameSystems.get(DestructibleObjectSystem.class, true))).getDestructibleCells(objectId);
        }
    }
}

